/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ffs")
public class ModConfig {
    @Config.Name(value="General")
    @Config.Comment(value={"General settings for configuring the mod."})
    public static final General general = new General();

    @Mod.EventBusSubscriber(modid="ffs")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ffs")) {
                ConfigManager.sync((String)"ffs", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class General {
        @Config.Name(value="mB Per Virtual Tank")
        @Config.Comment(value={"How many millibuckets can each block within the tank store?", "(Has to be higher than 1!)"})
        @Config.RangeInt(min=1)
        public int mbPerTankBlock = 16000;
        @Config.Name(value="Maximum Air Blocks")
        @Config.Comment(value={"Define the maximum number of air blocks a tank can have.", "2197 have been tested to not cause any noticeable lag."})
        @Config.RangeInt(min=3, max=2197)
        public int maxAirBlocks = 2197;
        @Config.Name(value="Block Blacklist")
        @Config.Comment(value={"Define a blacklist of blocks that can't be used as a frame in a tank.", "Registry names need to be used, example: minecraft:stone, minecraft:wool@3"})
        public String[] blockBlacklist = new String[0];
        @Config.Name(value="Block Blacklist Invert")
        @Config.Comment(value={"When enabled, this will turn the blacklist into a whitelist."})
        public boolean blockBlacklistInvert = false;
    }
}

