/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.network;

import com.lordmau5.ffs.tile.abstracts.AbstractTankTile;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.LayerBlockPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class FFSPacket {
    public abstract void encode(ByteBuf var1);

    public abstract void decode(ByteBuf var1);

    public static class Server {

        public static class OnTankRequest
        extends FFSPacket {
            private BlockPos pos;

            public OnTankRequest() {
            }

            public OnTankRequest(AbstractTankValve valve) {
                this.pos = valve.func_174877_v();
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeLong(this.pos.func_177986_g());
            }

            @Override
            public void decode(ByteBuf buffer) {
                this.pos = BlockPos.func_177969_a((long)buffer.readLong());
            }

            public BlockPos getPos() {
                return this.pos;
            }
        }

        public static class UpdateFluidLock
        extends FFSPacket {
            private BlockPos pos;
            private boolean fluidLock;

            public UpdateFluidLock() {
            }

            public UpdateFluidLock(AbstractTankValve valve) {
                this.pos = valve.func_174877_v();
                this.fluidLock = valve.getTankConfig().isFluidLocked();
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeLong(this.pos.func_177986_g());
                buffer.writeBoolean(this.fluidLock);
            }

            @Override
            public void decode(ByteBuf buffer) {
                this.pos = BlockPos.func_177969_a((long)buffer.readLong());
                this.fluidLock = buffer.readBoolean();
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public boolean isFluidLock() {
                return this.fluidLock;
            }
        }

        public static class UpdateTileName
        extends FFSPacket {
            private BlockPos pos;
            private String name;

            public UpdateTileName() {
            }

            public UpdateTileName(AbstractTankTile tankTile, String name) {
                this.pos = tankTile.func_174877_v();
                this.name = name;
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeLong(this.pos.func_177986_g());
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
            }

            @Override
            public void decode(ByteBuf buffer) {
                this.pos = BlockPos.func_177969_a((long)buffer.readLong());
                this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static abstract class Client {

        public static class OnTankBreak
        extends FFSPacket {
            private int dimensionId;
            private BlockPos valvePos;

            public OnTankBreak() {
            }

            public OnTankBreak(AbstractTankValve valve) {
                this.dimensionId = valve.func_145831_w().field_73011_w.getDimension();
                this.valvePos = valve.func_174877_v();
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeInt(this.dimensionId);
                buffer.writeLong(this.valvePos.func_177986_g());
            }

            @Override
            public void decode(ByteBuf buffer) {
                this.dimensionId = buffer.readInt();
                this.valvePos = BlockPos.func_177969_a((long)buffer.readLong());
            }

            public int getDimension() {
                return this.dimensionId;
            }

            public BlockPos getValvePos() {
                return this.valvePos;
            }
        }

        public static class OnTankBuild
        extends FFSPacket {
            private int dimensionId;
            private BlockPos valvePos;
            private TreeMap<Integer, List<LayerBlockPos>> airBlocks;
            private TreeMap<Integer, List<LayerBlockPos>> frameBlocks;

            public OnTankBuild() {
            }

            public OnTankBuild(AbstractTankValve valve) {
                this.dimensionId = valve.func_145831_w().field_73011_w.getDimension();
                this.valvePos = valve.func_174877_v();
                this.airBlocks = valve.getAirBlocks();
                this.frameBlocks = valve.getFrameBlocks();
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeInt(this.dimensionId);
                buffer.writeLong(this.valvePos.func_177986_g());
                buffer.writeInt(this.airBlocks.size());
                for (int layer : this.airBlocks.keySet()) {
                    buffer.writeInt(layer);
                    buffer.writeInt(this.airBlocks.get(layer).size());
                    for (LayerBlockPos pos : this.airBlocks.get(layer)) {
                        buffer.writeLong(pos.func_177986_g());
                        buffer.writeInt(pos.getLayer());
                    }
                }
                buffer.writeInt(this.frameBlocks.size());
                for (int layer : this.frameBlocks.keySet()) {
                    buffer.writeInt(layer);
                    buffer.writeInt(this.frameBlocks.get(layer).size());
                    for (LayerBlockPos pos : this.frameBlocks.get(layer)) {
                        buffer.writeLong(pos.func_177986_g());
                        buffer.writeInt(pos.getLayer());
                    }
                }
            }

            @Override
            public void decode(ByteBuf buffer) {
                int j;
                ArrayList<LayerBlockPos> layerBlocks;
                int layer;
                int i;
                this.dimensionId = buffer.readInt();
                this.valvePos = BlockPos.func_177969_a((long)buffer.readLong());
                this.airBlocks = new TreeMap();
                int layerSize = buffer.readInt();
                for (i = 0; i < layerSize; ++i) {
                    layer = buffer.readInt();
                    int airBlockSize = buffer.readInt();
                    layerBlocks = new ArrayList<LayerBlockPos>();
                    for (j = 0; j < airBlockSize; ++j) {
                        layerBlocks.add(new LayerBlockPos(BlockPos.func_177969_a((long)buffer.readLong()), buffer.readInt()));
                    }
                    this.airBlocks.put(layer, layerBlocks);
                }
                this.frameBlocks = new TreeMap();
                layerSize = buffer.readInt();
                for (i = 0; i < layerSize; ++i) {
                    layer = buffer.readInt();
                    int frameBlockSize = buffer.readInt();
                    layerBlocks = new ArrayList();
                    for (j = 0; j < frameBlockSize; ++j) {
                        layerBlocks.add(new LayerBlockPos(BlockPos.func_177969_a((long)buffer.readLong()), buffer.readInt()));
                    }
                    this.frameBlocks.put(layer, layerBlocks);
                }
            }

            public int getDimension() {
                return this.dimensionId;
            }

            public BlockPos getValvePos() {
                return this.valvePos;
            }

            public TreeMap<Integer, List<LayerBlockPos>> getAirBlocks() {
                return this.airBlocks;
            }

            public TreeMap<Integer, List<LayerBlockPos>> getFrameBlocks() {
                return this.frameBlocks;
            }
        }
    }
}

