/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.network;

import com.lordmau5.ffs.network.FFSPacket;
import com.lordmau5.ffs.network.PacketCodec;
import com.lordmau5.ffs.network.handlers.client.OnTankBreak;
import com.lordmau5.ffs.network.handlers.client.OnTankBuild;
import com.lordmau5.ffs.network.handlers.server.OnTankRequest;
import com.lordmau5.ffs.network.handlers.server.UpdateFluidLock_Server;
import com.lordmau5.ffs.network.handlers.server.UpdateTileName_Server;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkHandler {
    private static EnumMap<Side, FMLEmbeddedChannel> channels;

    public static void registerChannels(Side side) {
        channels = NetworkRegistry.INSTANCE.newChannel("ffs", new ChannelHandler[]{new PacketCodec()});
        ChannelPipeline pipeline = channels.get(Side.SERVER).pipeline();
        String targetName = channels.get(Side.SERVER).findChannelHandlerNameForType(PacketCodec.class);
        pipeline.addAfter(targetName, "UpdateTileName_Server", (ChannelHandler)new UpdateTileName_Server());
        pipeline.addAfter(targetName, "UpdateFluidLock_Server", (ChannelHandler)new UpdateFluidLock_Server());
        pipeline.addAfter(targetName, "OnTankRequest", (ChannelHandler)new OnTankRequest());
        if (side.isClient()) {
            NetworkHandler.registerClientHandlers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerClientHandlers() {
        ChannelPipeline pipeline = channels.get(Side.CLIENT).pipeline();
        String targetName = channels.get(Side.CLIENT).findChannelHandlerNameForType(PacketCodec.class);
        pipeline.addAfter(targetName, "OnTankBuild", (ChannelHandler)new OnTankBuild());
        pipeline.addAfter(targetName, "OnTankBreak", (ChannelHandler)new OnTankBreak());
    }

    public static Packet getProxyPacket(FFSPacket packet) {
        return channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    public static void sendPacketToPlayer(FFSPacket packet, EntityPlayer player) {
        FMLEmbeddedChannel channel = channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToAllPlayers(FFSPacket packet) {
        FMLEmbeddedChannel channel = channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToServer(FFSPacket packet) {
        FMLEmbeddedChannel channel = channels.get(Side.CLIENT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channel.writeOutbound(new Object[]{packet});
    }

    public static EntityPlayerMP getPlayer(ChannelHandlerContext ctx) {
        return ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
    }
}

