/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.tile.abstracts;

import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractTankTile
extends TileEntity
implements ITickable {
    protected EnumFacing tile_facing = null;
    String tile_name = "";
    private int needsUpdate = 0;
    private BlockPos masterValvePos;

    public void setNeedsUpdate() {
        if (this.needsUpdate == 0) {
            this.needsUpdate = 20;
        }
    }

    public void onLoad() {
        super.onLoad();
        this.setNeedsUpdate();
    }

    public boolean isValid() {
        return this.getMasterValve() != null && this.getMasterValve().isValid();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    void setValvePos(BlockPos masterValvePos) {
        this.masterValvePos = masterValvePos;
    }

    public AbstractTankValve getMasterValve() {
        if (this.func_145831_w() != null && this.masterValvePos != null) {
            TileEntity tile = this.func_145831_w().func_175625_s(this.masterValvePos);
            return tile instanceof AbstractTankValve ? (AbstractTankValve)tile : null;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setValvePos(tag.func_74764_b("valvePos") ? BlockPos.func_177969_a((long)tag.func_74763_f("valvePos")) : null);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.getMasterValve() != null) {
            tag.func_74772_a("valvePos", this.getMasterValve().func_174877_v().func_177986_g());
        }
        super.func_189515_b(tag);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        boolean oldIsValid = this.isValid();
        this.func_145839_a(pkt.func_148857_g());
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && oldIsValid != this.isValid()) {
            this.markForUpdateNow();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void markForUpdate() {
        if (this.func_145831_w() == null) {
            this.setNeedsUpdate();
            return;
        }
        if (--this.needsUpdate == 0) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
            this.func_70296_d();
        }
    }

    public void markForUpdateNow() {
        this.needsUpdate = 1;
        this.markForUpdate();
    }

    public void markForUpdateNow(int when) {
        this.needsUpdate = Math.min(when, 20);
        this.markForUpdate();
    }

    public void func_73660_a() {
        if (this.needsUpdate > 0) {
            this.markForUpdate();
        }
    }

    public int hashCode() {
        return this.func_174877_v().hashCode();
    }
}

