/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.tile.abstracts;

import com.google.common.collect.Lists;
import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.config.ModConfig;
import com.lordmau5.ffs.network.FFSPacket;
import com.lordmau5.ffs.network.NetworkHandler;
import com.lordmau5.ffs.tile.abstracts.AbstractTankTile;
import com.lordmau5.ffs.tile.interfaces.IFacingTile;
import com.lordmau5.ffs.tile.interfaces.INameableTile;
import com.lordmau5.ffs.tile.util.TankConfig;
import com.lordmau5.ffs.util.GenericUtil;
import com.lordmau5.ffs.util.LayerBlockPos;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractTankValve
extends AbstractTankTile
implements IFacingTile,
INameableTile {
    public final WeakHashMap<Integer, TreeMap<Integer, List<LayerBlockPos>>> maps;
    private final List<AbstractTankTile> tankTiles = new ArrayList<AbstractTankTile>();
    private int initialWaitTick = 20;
    private TankConfig tankConfig;
    private boolean isValid;
    private boolean isMaster;
    private boolean initiated;
    private int lastComparatorOut = 0;
    private EntityPlayer buildPlayer;

    public AbstractTankValve() {
        this.maps = new WeakHashMap();
        this.maps.put(0, new TreeMap());
        this.maps.put(1, new TreeMap());
        this.setValid(false);
        this.setValvePos(null);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initiated = true;
        this.initialWaitTick = 20;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.breakTank();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.breakTank();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.initiated && this.isMaster() && this.initialWaitTick-- <= 0) {
            this.initiated = false;
            this.buildTank(this.getTileFacing());
            return;
        }
        if (!this.isValid()) {
            return;
        }
        if (!this.isMaster() && this.getMasterValve() == null) {
            this.setValid(false);
            this.updateBlockAndNeighbors();
        }
    }

    public TreeMap<Integer, List<LayerBlockPos>> getFrameBlocks() {
        return this.maps.get(0);
    }

    public TreeMap<Integer, List<LayerBlockPos>> getAirBlocks() {
        return this.maps.get(1);
    }

    public TankConfig getTankConfig() {
        if (!this.isMaster() && this.getMasterValve() != null && this.getMasterValve() != this) {
            return this.getMasterValve().getTankConfig();
        }
        if (this.tankConfig == null) {
            this.tankConfig = new TankConfig(this);
        }
        return this.tankConfig;
    }

    private void setTankConfig(TankConfig tankConfig) {
        this.tankConfig = tankConfig;
    }

    public void toggleFluidLock(boolean state) {
        if (!state) {
            this.getTankConfig().unlockFluid();
        } else {
            if (this.getTankConfig().getFluidStack() == null) {
                return;
            }
            this.getTankConfig().lockFluid(this.getTankConfig().getFluidStack());
        }
        this.getMasterValve().setNeedsUpdate();
    }

    public <T> List<T> getTankTiles(Class<T> type) {
        List tiles = this.tankTiles.stream().filter(p -> type.isAssignableFrom(((Object)p).getClass())).map(p -> p).collect(Collectors.toList());
        if (this.getClass().isAssignableFrom(type)) {
            tiles.add(this);
        }
        return tiles;
    }

    public List<AbstractTankValve> getAllValves(boolean include) {
        if (!this.isMaster() && this.getMasterValve() != null && this.getMasterValve() != this) {
            return this.getMasterValve().getAllValves(include);
        }
        List<AbstractTankValve> valves = this.getTankTiles(AbstractTankValve.class);
        if (include) {
            valves.add(this);
        }
        return valves;
    }

    public void buildTank_player(EntityPlayer player, EnumFacing inside) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.buildPlayer = player;
        this.buildTank(inside);
    }

    private void buildTank(EnumFacing inside) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.setValid(false);
        this.getTankConfig().setFluidCapacity(0);
        this.tankTiles.clear();
        if (inside != null) {
            this.setTileFacing(inside);
        }
        if (!this.setupTank()) {
            return;
        }
        this.initiated = false;
        this.buildPlayer = null;
        this.updateBlockAndNeighbors();
    }

    private void setTankTileFacing(TreeMap<Integer, List<LayerBlockPos>> airBlocks, TileEntity tankTile) {
        ArrayList<BlockPos> possibleAirBlocks = new ArrayList<BlockPos>();
        for (EnumFacing dr : EnumFacing.field_82609_l) {
            if (!this.func_145831_w().func_175623_d(tankTile.func_174877_v().func_177972_a(dr))) continue;
            possibleAirBlocks.add(tankTile.func_174877_v().func_177972_a(dr));
        }
        BlockPos insideAir = null;
        block1: for (int layer : airBlocks.keySet()) {
            for (BlockPos pos : possibleAirBlocks) {
                if (!airBlocks.get(layer).contains(pos)) continue;
                insideAir = pos;
                continue block1;
            }
        }
        if (insideAir == null) {
            return;
        }
        BlockPos dist = insideAir.func_177973_b((Vec3i)tankTile.func_174877_v());
        for (EnumFacing dr : EnumFacing.field_82609_l) {
            if (!dist.equals((Object)new BlockPos(dr.func_82601_c(), dr.func_96559_d(), dr.func_82599_e()))) continue;
            ((IFacingTile)tankTile).setTileFacing(dr);
            break;
        }
    }

    private boolean searchAlgorithm() {
        int currentAirBlocks = 1;
        int maxAirBlocks = ModConfig.general.maxAirBlocks;
        BlockPos insidePos = this.func_174877_v().func_177972_a(this.getTileFacing());
        LinkedList<BlockPos> to_check = new LinkedList<BlockPos>();
        ArrayList<BlockPos> checked_blocks = new ArrayList<BlockPos>();
        TreeMap<Integer, ArrayList> air_blocks = new TreeMap<Integer, ArrayList>();
        TreeMap<Integer, ArrayList> frame_blocks = new TreeMap<Integer, ArrayList>();
        LayerBlockPos pos = new LayerBlockPos(insidePos, 0);
        air_blocks.put(0, Lists.newArrayList((Object[])new LayerBlockPos[]{pos}));
        to_check.add(insidePos);
        while (!to_check.isEmpty()) {
            BlockPos nextCheck = (BlockPos)to_check.remove();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = nextCheck.func_177972_a(facing);
                int layer = offsetPos.func_177956_o() - insidePos.func_177956_o();
                air_blocks.putIfAbsent(layer, Lists.newArrayList());
                frame_blocks.putIfAbsent(layer, Lists.newArrayList());
                if (checked_blocks.contains(offsetPos)) continue;
                checked_blocks.add(offsetPos);
                LayerBlockPos _pos = new LayerBlockPos(offsetPos, offsetPos.func_177956_o() - insidePos.func_177956_o());
                if (this.func_145831_w().func_175623_d(offsetPos)) {
                    if (((List)air_blocks.get(layer)).contains((Object)_pos)) continue;
                    ((List)air_blocks.get(layer)).add(_pos);
                    to_check.add(offsetPos);
                    ++currentAirBlocks;
                    continue;
                }
                if (this.isBlockBlacklisted(_pos)) {
                    return false;
                }
                ((List)frame_blocks.get(layer)).add(_pos);
            }
            if (currentAirBlocks <= maxAirBlocks) continue;
            if (this.buildPlayer != null) {
                GenericUtil.sendMessageToClient(this.buildPlayer, "chat.ffs.valve_too_much_air", false, maxAirBlocks);
            }
            return false;
        }
        if (currentAirBlocks == 0) {
            return false;
        }
        this.maps.put(0, frame_blocks);
        this.maps.put(1, air_blocks);
        return true;
    }

    private boolean isBlockBlacklisted(BlockPos pos) {
        if (this.field_145850_b.func_175625_s(pos) instanceof AbstractTankTile) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        String registryName = state.func_177230_c().getRegistryName().toString();
        String registryName_WithMetadata = registryName + "@" + metadata;
        for (String key : ModConfig.general.blockBlacklist) {
            if (!key.equalsIgnoreCase(registryName) && !key.equalsIgnoreCase(registryName_WithMetadata)) continue;
            return !ModConfig.general.blockBlacklistInvert;
        }
        return ModConfig.general.blockBlacklistInvert;
    }

    private boolean setupTank() {
        AbstractTankValve valve;
        if (!this.searchAlgorithm()) {
            return false;
        }
        int size = 0;
        for (int layer : this.maps.get(1).keySet()) {
            size += this.maps.get(1).get(layer).size();
        }
        this.getTankConfig().setFluidCapacity(size * ModConfig.general.mbPerTankBlock);
        for (int layer : this.maps.get(1).keySet()) {
            for (BlockPos blockPos : this.maps.get(1).get(layer)) {
                if (this.func_145831_w().func_175623_d(blockPos)) continue;
                return false;
            }
        }
        FluidStack tempNewFluidStack = this.getTankConfig().getFluidStack();
        ArrayList<TileEntity> facingTiles = new ArrayList<TileEntity>();
        Iterator<Object> iterator = this.maps.get(0).keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (BlockPos blockPos : this.maps.get(0).get(n)) {
                IBlockState check = this.func_145831_w().func_180495_p(blockPos);
                if (FancyFluidStorage.tankManager.isPartOfTank(this.func_145831_w(), blockPos)) {
                    valve = FancyFluidStorage.tankManager.getValveForBlock(this.func_145831_w(), blockPos);
                    if (valve == null || valve == this) continue;
                    GenericUtil.sendMessageToClient(this.buildPlayer, "chat.ffs.valve_other_tank", false);
                    return false;
                }
                TileEntity tile = this.func_145831_w().func_175625_s(blockPos);
                if (tile != null) {
                    if (tile instanceof IFacingTile) {
                        facingTiles.add(tile);
                    }
                    if (tile instanceof AbstractTankValve) {
                        AbstractTankValve valve2 = (AbstractTankValve)tile;
                        if (valve2 == this) continue;
                        if (valve2.getTankConfig().getFluidStack() != null) {
                            if (this.getTankConfig() != null && this.getTankConfig().getFluidStack() != null) {
                                FluidStack otherFS;
                                FluidStack myFS = this.getTankConfig().getFluidStack();
                                if (!myFS.isFluidEqual(otherFS = valve2.getTankConfig().getFluidStack())) {
                                    GenericUtil.sendMessageToClient(this.buildPlayer, "chat.ffs.valve_different_fluids", false);
                                    return false;
                                }
                            } else {
                                tempNewFluidStack = valve2.getTankConfig().getFluidStack();
                            }
                        }
                    }
                }
                if (GenericUtil.areTankBlocksValid(check, this.func_145831_w(), blockPos, GenericUtil.getInsideForTankFrame(this.getAirBlocks(), blockPos)) || GenericUtil.isBlockGlass(check)) continue;
                return false;
            }
        }
        this.getTankConfig().setFluidStack(tempNewFluidStack);
        if (this.getTankConfig().getFluidStack() != null) {
            this.getTankConfig().getFluidStack().amount = Math.min(this.getTankConfig().getFluidStack().amount, this.getTankConfig().getFluidCapacity());
        }
        for (TileEntity tileEntity : facingTiles) {
            this.setTankTileFacing(this.maps.get(1), tileEntity);
        }
        this.isMaster = true;
        iterator = this.maps.get(0).keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (BlockPos blockPos : this.maps.get(0).get(n)) {
                TileEntity tile = this.func_145831_w().func_175625_s(blockPos);
                if (tile == this || tile == null) continue;
                if (tile instanceof AbstractTankValve) {
                    valve = (AbstractTankValve)tile;
                    valve.isMaster = false;
                    valve.setValvePos(this.func_174877_v());
                    valve.setTankConfig(this.getTankConfig());
                    this.tankTiles.add(valve);
                    continue;
                }
                if (!(tile instanceof AbstractTankTile)) continue;
                AbstractTankTile tankTile = (AbstractTankTile)tile;
                tankTile.setValvePos(this.func_174877_v());
                this.tankTiles.add((AbstractTankTile)tile);
            }
        }
        this.setValid(true);
        FancyFluidStorage.tankManager.add(this.func_145831_w(), this.func_174877_v(), this.getAirBlocks(), this.getFrameBlocks());
        return true;
    }

    public void breakTank() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isMaster() && this.getMasterValve() != null && this.getMasterValve() != this) {
            this.getMasterValve().breakTank();
            return;
        }
        FancyFluidStorage.tankManager.remove(this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v());
        NetworkHandler.sendPacketToAllPlayers(new FFSPacket.Client.OnTankBreak(this));
        for (AbstractTankValve valve : this.getAllValves(false)) {
            if (valve == this) continue;
            valve.setTankConfig(null);
            valve.setValvePos(null);
            valve.setValid(false);
            valve.updateBlockAndNeighbors(true);
        }
        this.setValid(false);
        this.tankTiles.removeAll(this.getTankTiles(AbstractTankValve.class));
        for (AbstractTankTile tankTile : this.tankTiles) {
            tankTile.setValvePos(null);
        }
        this.tankTiles.clear();
        this.updateBlockAndNeighbors(true);
    }

    @Override
    public boolean isValid() {
        if (this.getMasterValve() == null || this.getMasterValve() == this) {
            return this.isValid;
        }
        return this.getMasterValve().isValid;
    }

    private void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    private void updateBlockAndNeighbors() {
        this.updateBlockAndNeighbors(false);
    }

    private void updateBlockAndNeighbors(boolean onlyThis) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.markForUpdateNow();
        if (!this.tankTiles.isEmpty() && !onlyThis) {
            for (AbstractTankTile tile : this.tankTiles) {
                if (tile == this) continue;
                tile.markForUpdateNow(2);
            }
        }
    }

    private void updateComparatorOutput() {
        if (this.lastComparatorOut != this.getComparatorOutput()) {
            this.lastComparatorOut = this.getComparatorOutput();
            if (this.isMaster()) {
                for (AbstractTankValve otherValve : this.getTankTiles(AbstractTankValve.class)) {
                    this.func_145831_w().func_175666_e(otherValve.func_174877_v(), otherValve.func_145838_q());
                }
            }
            this.func_145831_w().func_175666_e(this.func_174877_v(), this.func_145838_q());
        }
    }

    @Override
    public void markForUpdate() {
        this.updateComparatorOutput();
        super.markForUpdate();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public AbstractTankValve getMasterValve() {
        return this.isMaster() ? this : super.getMasterValve();
    }

    @Override
    public String getTileName() {
        if (this.tile_name.isEmpty()) {
            this.setTileName(GenericUtil.getUniquePositionName(this));
        }
        return this.tile_name;
    }

    @Override
    public void setTileName(String name) {
        this.tile_name = name;
    }

    @Override
    public EnumFacing getTileFacing() {
        return this.tile_facing;
    }

    @Override
    public void setTileFacing(EnumFacing facing) {
        this.tile_facing = facing;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isMaster = tag.func_74767_n("master");
        if (this.isMaster()) {
            this.isValid = tag.func_74767_n("isValid");
            this.getTankConfig().readFromNBT(tag);
            if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && this.isValid() && !FancyFluidStorage.tankManager.isValveInLists(this.func_145831_w(), this)) {
                NetworkHandler.sendPacketToServer(new FFSPacket.Server.OnTankRequest(this));
            }
        }
        this.readTileNameFromNBT(tag);
        this.readTileFacingFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("master", this.isMaster());
        if (this.isMaster()) {
            tag.func_74757_a("isValid", this.isValid());
            this.getTankConfig().writeToNBT(tag);
        }
        this.saveTileNameToNBT(tag);
        this.saveTileFacingToNBT(tag);
        super.func_189515_b(tag);
        return tag;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int fillFromContainer(FluidStack resource, boolean doFill) {
        if (!this.canFillIncludingContainers(resource)) {
            return 0;
        }
        return this.getTankConfig().getFluidTank().fill(resource, doFill);
    }

    private boolean canFillIncludingContainers(FluidStack fluid) {
        if (this.getTankConfig().getFluidStack() != null && !this.getTankConfig().getFluidStack().isFluidEqual(fluid)) {
            return false;
        }
        return !this.getTankConfig().isFluidLocked() || this.getTankConfig().getLockedFluid().isFluidEqual(fluid);
    }

    public int getComparatorOutput() {
        if (!this.isValid()) {
            return 0;
        }
        return MathHelper.func_76141_d((float)((float)this.getTankConfig().getFluidAmount() / (float)this.getTankConfig().getFluidCapacity() * 14.0f));
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractTankValve && ((AbstractTankValve)obj).func_174877_v().equals((Object)this.func_174877_v());
    }
}

