/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.tile.tanktiles;

import com.lordmau5.ffs.tile.abstracts.AbstractTankTile;
import com.lordmau5.ffs.tile.interfaces.IFacingTile;
import com.lordmau5.ffs.tile.valves.TileEntityFluidValve;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityTankComputer
extends AbstractTankTile
implements IFacingTile {
    public List<TileEntityFluidValve> getValves() {
        return this.getMasterValve().getAllValves(true).stream().filter(p -> p instanceof TileEntityFluidValve).map(p -> (TileEntityFluidValve)p).collect(Collectors.toList());
    }

    public List<TileEntityFluidValve> getValvesByName(String name) {
        ArrayList<TileEntityFluidValve> valves = new ArrayList<TileEntityFluidValve>();
        if (this.getValves().isEmpty()) {
            return valves;
        }
        for (TileEntityFluidValve valve : this.getValves()) {
            if (!valve.getTileName().toLowerCase().equals(name.toLowerCase())) continue;
            valves.add(valve);
        }
        return valves;
    }

    @Override
    public EnumFacing getTileFacing() {
        if (this.getMasterValve() == null || !this.getMasterValve().isValid()) {
            return null;
        }
        return this.tile_facing;
    }

    @Override
    public void setTileFacing(EnumFacing facing) {
        this.tile_facing = facing;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readTileFacingFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.saveTileFacingToNBT(tag);
        return tag;
    }

    public String[] methodNames() {
        return new String[]{"getFluidName", "getFluidAmount", "getFluidCapacity", "setAutoOutput", "doesAutoOutput", "isFluidLocked", "getLockedFluid", "toggleFluidLock"};
    }
}

