/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.tile.util;

import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.tile.util.InternalFluidTank;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TankConfig {
    private final InternalFluidTank fluidTank;
    private FluidStack lockedFluid;

    public TankConfig(AbstractTankValve valve) {
        this.fluidTank = new InternalFluidTank(valve);
    }

    private void resetVariables() {
        this.lockedFluid = null;
        this.fluidTank.setFluid(null);
        this.fluidTank.setCapacity(0);
    }

    public void lockFluid(FluidStack lockedFluid) {
        this.lockedFluid = lockedFluid;
    }

    public void unlockFluid() {
        this.lockedFluid = null;
    }

    public boolean isFluidLocked() {
        return this.lockedFluid != null;
    }

    public FluidStack getLockedFluid() {
        return this.lockedFluid;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidStack getFluidStack() {
        return this.fluidTank.getFluid();
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidTank.setFluid(fluidStack);
    }

    public int getFluidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public void setFluidCapacity(int fluidCapacity) {
        this.fluidTank.setCapacity(fluidCapacity);
    }

    public int getFluidAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public void readFromNBT(NBTTagCompound mainTag) {
        NBTBase base;
        this.resetVariables();
        if (!mainTag.func_74764_b("tankConfig")) {
            return;
        }
        this.getFluidTank().readFromNBT(mainTag);
        NBTTagCompound tag = mainTag.func_74775_l("tankConfig");
        if (tag.func_74764_b("lockedFluid") && (base = tag.func_74781_a("lockedFluid")) instanceof NBTTagCompound) {
            this.lockFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)base)));
        }
        this.setFluidCapacity(tag.func_74762_e("capacity"));
    }

    public void writeToNBT(NBTTagCompound mainTag) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.getLockedFluid() != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.getLockedFluid().writeToNBT(fluidTag);
            tag.func_74782_a("lockedFluid", (NBTBase)fluidTag);
        }
        tag.func_74768_a("capacity", this.getFluidCapacity());
        this.getFluidTank().writeToNBT(mainTag);
        mainTag.func_74782_a("tankConfig", (NBTBase)tag);
    }
}

