/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.util;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.compat.Compatibility;
import com.lordmau5.ffs.compat.cnb.CNBAPIAccess;
import com.lordmau5.ffs.compat.cnb.CNBCompatibility;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.LayerBlockPos;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GenericUtil {
    private static List<Block> blacklistedBlocks;
    private static Map<World, ForgeChunkManager.Ticket> chunkloadTicketMap;

    public static void init() {
        blacklistedBlocks = new ArrayList<Block>();
        blacklistedBlocks.add((Block)Blocks.field_150349_c);
        blacklistedBlocks.add(Blocks.field_150346_d);
        blacklistedBlocks.add(Blocks.field_150357_h);
        blacklistedBlocks.add(Blocks.field_150360_v);
        chunkloadTicketMap = new HashMap<World, ForgeChunkManager.Ticket>();
    }

    public static String getUniquePositionName(AbstractTankValve valve) {
        return "tile_" + Long.toHexString(valve.func_174877_v().func_177986_g());
    }

    public static boolean isBlockGlass(IBlockState blockState) {
        if (blockState == null || blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_177230_c() instanceof BlockGlass) {
            return true;
        }
        ItemStack is = new ItemStack(blockState.func_177230_c(), 1);
        return blockState.func_185904_a() == Material.field_151592_s && !is.func_77977_a().contains("pane");
    }

    public static EnumFacing getInsideForTankFrame(TreeMap<Integer, List<LayerBlockPos>> airBlocks, BlockPos frame) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            for (int layer : airBlocks.keySet()) {
                if (!airBlocks.get(layer).contains(frame.func_177972_a(facing))) continue;
                return facing;
            }
        }
        return null;
    }

    public static boolean areTankBlocksValid(IBlockState bottomBlock, World world, BlockPos bottomPos, EnumFacing facing) {
        return GenericUtil.isValidTankBlock(world, bottomPos, bottomBlock, facing);
    }

    public static boolean isValidTankBlock(World world, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (state == null) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockFalling) {
            return false;
        }
        if (Compatibility.INSTANCE.isCNBLoaded && CNBAPIAccess.apiInstance.isBlockChiseled(world, pos)) {
            return facing != null && CNBCompatibility.INSTANCE.isValid(world, pos, facing);
        }
        return GenericUtil.isBlockGlass(state) || facing == null || world.isSideSolid(pos, facing);
    }

    public static boolean isFluidContainer(ItemStack playerItem) {
        return FluidUtil.getFluidHandler((ItemStack)playerItem) != null;
    }

    public static boolean fluidContainerHandler(World world, AbstractTankValve valve, EntityPlayer player) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack current = player.func_184614_ca();
        if (current != ItemStack.field_190927_a) {
            if (!GenericUtil.isFluidContainer(current)) {
                return false;
            }
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (IFluidHandler)valve.getTankConfig().getFluidTank());
        }
        return false;
    }

    public static String intToFancyNumber(int number) {
        return NumberFormat.getIntegerInstance(Locale.ENGLISH).format(number);
    }

    public static void sendMessageToClient(EntityPlayer player, String key, boolean actionBar) {
        if (player == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation(key, new Object[0]), actionBar);
    }

    public static void sendMessageToClient(EntityPlayer player, String key, boolean actionBar, Object ... args) {
        if (player == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation(key, args), actionBar);
    }

    public static void initChunkLoadTicket(World world, ForgeChunkManager.Ticket ticket) {
        chunkloadTicketMap.put(world, ticket);
    }

    public static ForgeChunkManager.Ticket getChunkLoadTicket(World world) {
        if (chunkloadTicketMap.containsKey(world)) {
            return chunkloadTicketMap.get(world);
        }
        ForgeChunkManager.Ticket chunkloadTicket = ForgeChunkManager.requestTicket((Object)FancyFluidStorage.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        chunkloadTicketMap.put(world, chunkloadTicket);
        return chunkloadTicket;
    }
}

