/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.ffs.util;

import com.lordmau5.ffs.FancyFluidStorage;
import com.lordmau5.ffs.block.abstracts.AbstractBlockValve;
import com.lordmau5.ffs.tile.abstracts.AbstractTankValve;
import com.lordmau5.ffs.util.GenericUtil;
import com.lordmau5.ffs.util.LayerBlockPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TankManager {
    private final WeakHashMap<Integer, WeakHashMap<BlockPos, TreeMap<Integer, List<LayerBlockPos>>>> valveToFrameBlocks = new WeakHashMap();
    private final WeakHashMap<Integer, WeakHashMap<BlockPos, TreeMap<Integer, List<LayerBlockPos>>>> valveToAirBlocks = new WeakHashMap();
    private final WeakHashMap<Integer, WeakHashMap<BlockPos, BlockPos>> frameBlockToValve = new WeakHashMap();
    private final WeakHashMap<Integer, WeakHashMap<BlockPos, BlockPos>> airBlockToValve = new WeakHashMap();
    private final WeakHashMap<Integer, List<BlockPos>> blocksToCheck = new WeakHashMap();

    private int getDimensionSafely(World world) {
        return this.getDimensionSafely(world.field_73011_w.getDimension());
    }

    private int getDimensionSafely(int dimensionId) {
        this.valveToFrameBlocks.putIfAbsent(dimensionId, new WeakHashMap());
        this.valveToAirBlocks.putIfAbsent(dimensionId, new WeakHashMap());
        this.frameBlockToValve.putIfAbsent(dimensionId, new WeakHashMap());
        this.airBlockToValve.putIfAbsent(dimensionId, new WeakHashMap());
        this.blocksToCheck.putIfAbsent(dimensionId, new ArrayList());
        return dimensionId;
    }

    public void add(World world, BlockPos valvePos, TreeMap<Integer, List<LayerBlockPos>> airBlocks, TreeMap<Integer, List<LayerBlockPos>> frameBlocks) {
        if (airBlocks.isEmpty()) {
            return;
        }
        TileEntity tile = world.func_175625_s(valvePos);
        if (tile == null || !(tile instanceof AbstractTankValve)) {
            return;
        }
        if (!((AbstractTankValve)tile).isMaster()) {
            return;
        }
        this.addIgnore(world.field_73011_w.getDimension(), valvePos, airBlocks, frameBlocks);
    }

    public void addIgnore(int dimensionId, BlockPos valvePos, TreeMap<Integer, List<LayerBlockPos>> airBlocks, TreeMap<Integer, List<LayerBlockPos>> frameBlocks) {
        dimensionId = this.getDimensionSafely(dimensionId);
        this.valveToAirBlocks.get(dimensionId).put(valvePos, airBlocks);
        for (int layer : airBlocks.keySet()) {
            for (LayerBlockPos pos : airBlocks.get(layer)) {
                this.airBlockToValve.get(dimensionId).put(pos, valvePos);
            }
        }
        this.valveToFrameBlocks.get(dimensionId).put(valvePos, frameBlocks);
        for (int layer : frameBlocks.keySet()) {
            for (LayerBlockPos pos : frameBlocks.get(layer)) {
                this.frameBlockToValve.get(dimensionId).put(pos, valvePos);
            }
        }
    }

    public void remove(int dimensionId, BlockPos valve) {
        dimensionId = this.getDimensionSafely(dimensionId);
        this.airBlockToValve.get(dimensionId).values().removeAll(Collections.singleton(valve));
        this.valveToAirBlocks.get(dimensionId).remove(valve);
        this.frameBlockToValve.get(dimensionId).values().removeAll(Collections.singleton(valve));
        this.valveToFrameBlocks.get(dimensionId).remove(valve);
    }

    public void removeAllForDimension(int dimensionId) {
        dimensionId = this.getDimensionSafely(dimensionId);
        this.valveToAirBlocks.get(dimensionId).clear();
        this.valveToFrameBlocks.get(dimensionId).clear();
        this.airBlockToValve.get(dimensionId).clear();
        this.frameBlockToValve.get(dimensionId).clear();
        this.blocksToCheck.get(dimensionId).clear();
    }

    public AbstractTankValve getValveForBlock(World world, BlockPos pos) {
        if (!this.isPartOfTank(world, pos)) {
            return null;
        }
        int dimensionId = this.getDimensionSafely(world);
        TileEntity tile = null;
        if (this.frameBlockToValve.get(dimensionId).containsKey(pos)) {
            tile = world.func_175625_s(this.frameBlockToValve.get(dimensionId).get(pos));
        } else if (this.airBlockToValve.get(dimensionId).containsKey(pos)) {
            tile = world.func_175625_s(this.airBlockToValve.get(dimensionId).get(pos));
        }
        return tile instanceof AbstractTankValve ? (AbstractTankValve)tile : null;
    }

    public List<BlockPos> getFrameBlocksForValve(AbstractTankValve valve) {
        int dimensionId = this.getDimensionSafely(valve.func_145831_w());
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        if (this.valveToFrameBlocks.get(dimensionId).containsKey(valve.func_174877_v())) {
            for (int layer : this.valveToFrameBlocks.get(dimensionId).get(valve.func_174877_v()).keySet()) {
                blocks.addAll((Collection<BlockPos>)this.valveToFrameBlocks.get(dimensionId).get(valve.func_174877_v()).get(layer));
            }
        }
        return blocks;
    }

    public TreeMap<Integer, List<LayerBlockPos>> getAirBlocksForValve(AbstractTankValve valve) {
        int dimensionId = this.getDimensionSafely(valve.func_145831_w());
        if (this.valveToAirBlocks.get(dimensionId).containsKey(valve.func_174877_v())) {
            return this.valveToAirBlocks.get(dimensionId).get(valve.func_174877_v());
        }
        return null;
    }

    public boolean isValveInLists(World world, AbstractTankValve valve) {
        int dimensionId = this.getDimensionSafely(world);
        return this.valveToAirBlocks.get(dimensionId).containsKey(valve.func_174877_v());
    }

    public boolean isPartOfTank(World world, BlockPos pos) {
        int dimensionId = this.getDimensionSafely(world);
        return this.frameBlockToValve.getOrDefault(dimensionId, new WeakHashMap()).containsKey(pos) || this.airBlockToValve.getOrDefault(dimensionId, new WeakHashMap()).containsKey(pos);
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld() == null || event.getEntity() == null) {
            return;
        }
        if (!(event.getEntity() instanceof EntityCreature)) {
            return;
        }
        if (this.isPartOfTank(event.getWorld(), event.getEntity().func_180425_c())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        int dimensionId = event.world.field_73011_w.getDimension();
        if (this.blocksToCheck.isEmpty() || this.blocksToCheck.get(dimensionId) == null || this.blocksToCheck.get(dimensionId).isEmpty()) {
            return;
        }
        for (BlockPos pos : this.blocksToCheck.get(dimensionId)) {
            AbstractTankValve valve;
            if (!this.isPartOfTank(event.world, pos) || (valve = this.getValveForBlock(event.world, pos)) == null || GenericUtil.isValidTankBlock(event.world, pos, event.world.func_180495_p(pos), GenericUtil.getInsideForTankFrame(valve.getAirBlocks(), pos))) continue;
            valve.breakTank();
            break;
        }
        this.blocksToCheck.get(dimensionId).clear();
    }

    private void addBlockForCheck(World world, BlockPos pos) {
        int dimensionId = this.getDimensionSafely(world);
        List<BlockPos> blocks = this.blocksToCheck.get(dimensionId);
        if (blocks == null) {
            blocks = new ArrayList<BlockPos>();
        }
        blocks.add(pos);
        this.blocksToCheck.put(dimensionId, blocks);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.field_72995_K) {
            return;
        }
        if (!this.isPartOfTank(world, pos)) {
            return;
        }
        this.addBlockForCheck(world, pos);
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.field_72995_K) {
            return;
        }
        if (!this.isPartOfTank(world, pos)) {
            return;
        }
        this.addBlockForCheck(world, pos);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        AbstractTankValve valve;
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        if (!this.isPartOfTank(world, pos)) {
            return;
        }
        if (event.getHand() == EnumHand.OFF_HAND) {
            event.setCanceled(true);
            return;
        }
        if (player.func_184592_cb() != ItemStack.field_190927_a && player.func_184592_cb().func_77973_b() == FancyFluidStorage.itemTit) {
            return;
        }
        if (world.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof AbstractBlockValve) {
            return;
        }
        event.setCanceled(true);
        if (player.func_70093_af()) {
            ItemStack mainHand = player.func_184614_ca();
            if (mainHand != ItemStack.field_190927_a) {
                if (player.func_184812_l_()) {
                    mainHand = mainHand.func_77946_l();
                }
                mainHand.func_179546_a(player, world, pos, EnumHand.MAIN_HAND, event.getFace(), (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c);
            }
            return;
        }
        AbstractTankValve tile = this.getValveForBlock(world, pos);
        if (tile != null && tile.getMasterValve() != null && (valve = tile.getMasterValve()).isValid()) {
            if (GenericUtil.isFluidContainer(event.getItemStack())) {
                if (GenericUtil.fluidContainerHandler(world, valve, player)) {
                    valve.markForUpdateNow();
                }
            } else {
                player.openGui((Object)FancyFluidStorage.INSTANCE, 1, tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        if (event.getEntityPlayer().func_70093_af()) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        BlockPos pos = event.getTarget().func_178782_a();
        if (!this.isPartOfTank(event.getWorld(), pos)) {
            return;
        }
        event.setCanceled(true);
    }
}

