/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.apiimpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import teamroots.embers.api.itemmod.IItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.util.ItemModUtil;

class ItemModUtilImpl
implements IItemModUtil {
    ItemModUtilImpl() {
    }

    @Override
    public Collection<ModifierBase> getAllModifiers() {
        return ItemModUtil.modifierRegistry.values();
    }

    @Override
    public List<ItemStack> getAllModifierItems() {
        return ItemModUtil.modifierRegistry.keySet().stream().map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public ModifierBase getModifier(String name) {
        return ItemModUtil.nameToModifier.get(name);
    }

    @Override
    public ModifierBase getModifier(ItemStack modStack) {
        return ItemModUtil.modifierRegistry.get(modStack.func_77973_b());
    }

    @Override
    public boolean isModValid(ItemStack stack, ModifierBase modifier) {
        return modifier.canApplyTo(stack);
    }

    @Override
    public List<ModifierBase> getModifiers(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        NBTTagList tagModifiers = tagCompound.func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10);
        if (tagModifiers.func_74745_c() > 0) {
            ArrayList<ModifierBase> results = new ArrayList<ModifierBase>();
            for (int i = 0; i < tagModifiers.func_74745_c(); ++i) {
                NBTTagCompound tagModifier = tagModifiers.func_150305_b(i);
                String name = tagModifier.func_74779_i("name");
                ModifierBase modifier = this.getModifier(name);
                if (modifier == null) continue;
                results.add(modifier);
            }
            return results;
        }
        return Lists.newArrayList();
    }

    @Override
    public int getTotalModifierLevel(ItemStack stack) {
        return ItemModUtil.getTotalModLevel(stack);
    }

    @Override
    public boolean hasModifier(ItemStack stack, ModifierBase modifier) {
        return ItemModUtil.hasModifier(stack, modifier.name);
    }

    @Override
    public void addModifier(ItemStack stack, ItemStack modifier) {
        ItemModUtil.addModifier(stack, modifier);
    }

    @Override
    public List<ItemStack> removeAllModifiers(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        NBTTagList tagModifiers = tagCompound.func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10);
        if (tagModifiers.func_74745_c() > 0) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            NBTTagList remainingModifiers = new NBTTagList();
            ArrayList<ModifierBase> removedModifiers = new ArrayList<ModifierBase>();
            for (int i = 0; i < tagModifiers.func_74745_c(); ++i) {
                NBTTagCompound tagModifier = tagModifiers.func_150305_b(i);
                ItemStack s = new ItemStack(tagModifier.func_74775_l("item"));
                ModifierBase modifier = this.getModifier(s);
                if (modifier == null) continue;
                if (modifier.canRemove) {
                    for (int j = 0; j < tagModifier.func_74762_e("level"); ++j) {
                        removedModifiers.add(modifier);
                        results.add(new ItemStack(tagModifier.func_74775_l("item")));
                    }
                    continue;
                }
                remainingModifiers.func_74742_a((NBTBase)tagModifier);
            }
            tagCompound.func_74775_l("embers:heat_tag").func_74782_a("modifiers", (NBTBase)remainingModifiers);
            for (ModifierBase modifier : removedModifiers) {
                modifier.onRemove(stack);
            }
            return results;
        }
        return Lists.newArrayList();
    }

    @Override
    public void addModifierLevel(ItemStack stack, ModifierBase modifier, int levels) {
        this.setModifierLevel(stack, modifier, this.getModifierLevel(stack, modifier) + levels);
    }

    @Override
    public void setModifierLevel(ItemStack stack, ModifierBase modifier, int level) {
        ItemModUtil.setModifierLevel(stack, modifier.name, level);
    }

    @Override
    public int getModifierLevel(ItemStack stack, ModifierBase modifier) {
        return ItemModUtil.getModifierLevel(stack, modifier.name);
    }

    @Override
    public boolean hasHeat(ItemStack stack) {
        return ItemModUtil.hasHeat(stack);
    }

    @Override
    public void addHeat(ItemStack stack, float heat) {
        ItemModUtil.addHeat(stack, heat);
    }

    @Override
    public void setHeat(ItemStack stack, float heat) {
        ItemModUtil.setHeat(stack, heat);
    }

    @Override
    public float getHeat(ItemStack stack) {
        return ItemModUtil.getHeat(stack);
    }

    @Override
    public float getMaxHeat(ItemStack stack) {
        return ItemModUtil.getMaxHeat(stack);
    }

    @Override
    public int getLevel(ItemStack stack) {
        return ItemModUtil.getLevel(stack);
    }

    @Override
    public void setLevel(ItemStack stack, int level) {
        ItemModUtil.setLevel(stack, level);
    }

    @Override
    public int getArmorModifierLevel(EntityLivingBase p, ModifierBase modifier) {
        return ItemModUtil.getArmorMod(p, modifier.name);
    }
}

