/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.recipe.HeatCoilRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.HeatCoil")
public class HeatCoil {
    public static final String NAME = "HeatCoil";
    public static final String CLASS = "mods.embers.HeatCoil";

    @ZenMethod
    public static void add(IItemStack output, IIngredient input) {
        HeatCoilRecipe recipe = new HeatCoilRecipe(CraftTweakerMC.getItemStack((IItemStack)output), CTUtil.toIngredient(input));
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static List<HeatCoilRecipe> getRecipesByInput(ItemStack stack) {
        return RecipeRegistry.heatCoilRecipes.stream().filter(recipe -> recipe.matches(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveAll
    implements IAction {
        protected RemoveAll() {
        }

        public void apply() {
            RecipeRegistry.heatCoilRecipes.clear();
        }

        public String describe() {
            return String.format("Removing all %s recipes", HeatCoil.NAME);
        }
    }

    public static class RemoveByInput
    implements IAction {
        ItemStack input;

        protected RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            RecipeRegistry.heatCoilRecipes.removeAll(HeatCoil.getRecipesByInput(this.input));
        }

        public String describe() {
            return String.format("Removing %s recipes with input: %s", HeatCoil.NAME, this.input.toString());
        }
    }

    public static class Add
    implements IAction {
        HeatCoilRecipe recipe;

        public Add(HeatCoilRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.heatCoilRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", HeatCoil.NAME, this.recipe.toString());
        }
    }
}

