/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageItemUpdate
implements IMessage {
    public NBTTagCompound tag = new NBTTagCompound();
    public int slot = 0;
    public UUID id = null;

    public MessageItemUpdate() {
    }

    public MessageItemUpdate(UUID id, int slot, NBTTagCompound tag) {
        this.tag = tag;
        this.id = id;
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.slot = buf.readInt();
        this.id = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeInt(this.slot);
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
    }

    public static class MessageHolder
    implements IMessageHandler<MessageItemUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageItemUpdate message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(message.id);
                if (player != null) {
                    player.field_71071_by.func_70301_a(message.slot).func_77982_d(message.tag);
                }
            });
            return null;
        }
    }
}

