/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.proxy;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.api.event.InfoGogglesEvent;
import teamroots.embers.api.item.IInfoGoggles;
import teamroots.embers.compat.BaublesIntegration;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.model.ModelManager;
import teamroots.embers.particle.ParticleRenderer;
import teamroots.embers.proxy.CommonProxy;
import teamroots.embers.util.DecimalFormats;
import teamroots.embers.util.FluidColorHelper;
import teamroots.embers.util.sound.ItemUseSound;
import teamroots.embers.util.sound.MachineSound;

public class ClientProxy
extends CommonProxy {
    public static ParticleRenderer particleRenderer = new ParticleRenderer();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ModelManager.init();
        RegistryManager.registerEntityRendering();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        RegistryManager.registerColorHandlers();
        if (ConfigManager.isBaublesIntegrationEnabled()) {
            BaublesIntegration.registerClientSide();
        }
        if (ConfigManager.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.registerClientSide();
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new DecimalFormats());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new FluidColorHelper());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public boolean isPlayerWearingGoggles() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean shouldDisplay = this.isGoggles((EntityPlayer)player, EntityEquipmentSlot.HEAD) || this.isGoggles((EntityPlayer)player, EntityEquipmentSlot.MAINHAND) || this.isGoggles((EntityPlayer)player, EntityEquipmentSlot.OFFHAND);
        InfoGogglesEvent event = new InfoGogglesEvent((EntityPlayer)player, shouldDisplay);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.shouldDisplay();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private boolean isGoggles(EntityPlayer player, EntityEquipmentSlot slot) {
        ItemStack stack = player.func_184582_a(slot);
        Item item = stack.func_77973_b();
        return item instanceof IInfoGoggles && ((IInfoGoggles)item).shouldDisplayInfo(player, stack, slot);
    }

    @Override
    public void playItemSound(EntityLivingBase entity, Item item, SoundEvent soundIn, SoundCategory categoryIn, boolean repeat, float volume, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ItemUseSound(entity, item, soundIn, categoryIn, repeat, volume, pitch));
    }

    @Override
    public void playMachineSound(TileEntity tile, int id, SoundEvent soundIn, SoundCategory categoryIn, boolean repeat, float volume, float pitch, float xIn, float yIn, float zIn) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MachineSound(tile, id, soundIn, categoryIn, repeat, volume, pitch, xIn, yIn, zIn));
    }

    @Override
    public DecimalFormat getDecimalFormat(String key) {
        return DecimalFormats.getDecimalFormat(key);
    }

    @Override
    public String formatLocalize(String translationKey, Object ... parameters) {
        return I18n.func_135052_a((String)translationKey, (Object[])parameters);
    }
}

