/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.alchemy.AlchemyResult;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.api.event.AlchemyResultEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.ISparkable;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSphereFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityAlchemyPedestal;
import teamroots.embers.util.AlchemyUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityAlchemyTablet
extends TileEntity
implements ITileEntityBase,
ITickable,
ISparkable,
ISoundController,
IExtraCapabilityInformation {
    public static final EnumFacing[] UPGRADE_SIDES = new EnumFacing[]{EnumFacing.DOWN};
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    public int progress = 0;
    public int process = 0;
    @Deprecated
    int copper = 0;
    @Deprecated
    int iron = 0;
    @Deprecated
    int dawnstone = 0;
    @Deprecated
    int silver = 0;
    @Deprecated
    int lead = 0;
    private AspectList aspects = new AspectList();
    public ItemStackHandler north = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
        }
    };
    public ItemStackHandler south = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
        }
    };
    public ItemStackHandler east = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
        }
    };
    public ItemStackHandler west = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
        }
    };
    public ItemStackHandler center = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
        }
    };
    Random random = new Random();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74782_a("aspects", (NBTBase)this.aspects.serializeNBT());
        tag.func_74782_a("north", (NBTBase)this.north.serializeNBT());
        tag.func_74782_a("south", (NBTBase)this.south.serializeNBT());
        tag.func_74782_a("east", (NBTBase)this.east.serializeNBT());
        tag.func_74782_a("west", (NBTBase)this.west.serializeNBT());
        tag.func_74782_a("center", (NBTBase)this.center.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("progress");
        this.aspects.deserializeNBT(tag.func_74775_l("aspects"));
        this.north.deserializeNBT(tag.func_74775_l("north"));
        this.south.deserializeNBT(tag.func_74775_l("south"));
        this.east.deserializeNBT(tag.func_74775_l("east"));
        this.west.deserializeNBT(tag.func_74775_l("west"));
        this.center.deserializeNBT(tag.func_74775_l("center"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.center;
            }
            if (facing == EnumFacing.NORTH) {
                return (T)this.north;
            }
            if (facing == EnumFacing.SOUTH) {
                return (T)this.south;
            }
            if (facing == EnumFacing.EAST) {
                return (T)this.east;
            }
            if (facing == EnumFacing.WEST) {
                return (T)this.west;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlotForPos(float hitX, float hitZ) {
        return (int)((double)hitX / 0.3333) * 3 + (int)((double)hitZ / 0.3333);
    }

    public ItemStackHandler getInventoryForFace(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return this.center;
        }
        if (facing == EnumFacing.NORTH) {
            return this.north;
        }
        if (facing == EnumFacing.SOUTH) {
            return this.south;
        }
        if (facing == EnumFacing.EAST) {
            return this.east;
        }
        if (facing == EnumFacing.WEST) {
            return this.west;
        }
        return this.center;
    }

    @Deprecated
    public void sparkProgress() {
        this.sparkProgress(null, 0.0);
    }

    @Override
    public void sparkProgress(TileEntity tile, double ember) {
        if (this.progress != 0) {
            return;
        }
        AlchemyRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return;
        }
        List<TileEntityAlchemyPedestal> pedestals = AlchemyUtil.getNearbyPedestals(this.func_145831_w(), this.func_174877_v());
        AspectList list = new AspectList();
        list.collect(pedestals);
        AlchemyResult result = recipe.matchAshes(list, this.field_145850_b);
        if (result.areAllPresent()) {
            this.aspects.reset();
            this.progress = 1;
            this.func_70296_d();
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundManager.ALCHEMY_START, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private AlchemyRecipe getRecipe() {
        AlchemyRecipe recipe = RecipeRegistry.getAlchemyRecipe(this.center.getStackInSlot(0), Lists.newArrayList((Object[])new ItemStack[]{this.north.getStackInSlot(0), this.east.getStackInSlot(0), this.south.getStackInSlot(0), this.west.getStackInSlot(0)}));
        MachineRecipeEvent<AlchemyRecipe> event = new MachineRecipeEvent<AlchemyRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, new ArrayList<IUpgradeProvider>());
        return event.getRecipe();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            player.func_184611_a(hand, this.getInventoryForFace(side).insertItem(0, heldItem, false));
            this.func_70296_d();
            return true;
        }
        if (!this.getInventoryForFace(side).getStackInSlot(0).func_190926_b()) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_184611_a(hand, this.getInventoryForFace(side).extractItem(0, this.getInventoryForFace(side).getStackInSlot(0).func_190916_E(), false));
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.north);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.south);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.east);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.west);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.center);
        world.func_175690_a(pos, null);
    }

    public List<TileEntityAlchemyPedestal> getNearbyPedestals() {
        ArrayList<TileEntityAlchemyPedestal> pedestals = new ArrayList<TileEntityAlchemyPedestal>();
        for (int i = -3; i < 4; ++i) {
            for (int j = -3; j < 4; ++j) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(i, 1, j));
                if (!(tile instanceof TileEntityAlchemyPedestal)) continue;
                pedestals.add((TileEntityAlchemyPedestal)tile);
            }
        }
        return pedestals;
    }

    public int getNearbyAsh(List<TileEntityAlchemyPedestal> pedestals) {
        int count = 0;
        for (TileEntityAlchemyPedestal pedestal : pedestals) {
            if (pedestal.inventory.getStackInSlot(0).func_190926_b()) continue;
            count += pedestal.inventory.getStackInSlot(0).func_190916_E();
        }
        return count;
    }

    public void func_73660_a() {
        this.angle = (int)((float)this.angle + 1.0f);
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        if (this.progress == 1) {
            if (this.process < 20) {
                ++this.process;
            }
            List<TileEntityAlchemyPedestal> pedestals = AlchemyUtil.getNearbyPedestals(this.func_145831_w(), this.func_174877_v());
            for (TileEntityAlchemyPedestal pedestal : pedestals) {
                if (pedestal != null && !pedestal.inventory.getStackInSlot(1).func_190926_b()) {
                    pedestal.setActive(3);
                }
                if (!this.func_145831_w().field_72995_K) continue;
                ParticleUtil.spawnParticleStar(this.func_145831_w(), (float)pedestal.func_174877_v().func_177958_n() + 0.5f, (float)pedestal.func_174877_v().func_177956_o() + 1.0f, (float)pedestal.func_174877_v().func_177952_p() + 0.5f, 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 3.5f + 0.5f * this.random.nextFloat(), 40);
                for (int j = 0; j < 8; ++j) {
                    float coeff = this.random.nextFloat();
                    float x = ((float)this.func_174877_v().func_177958_n() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestal.func_174877_v().func_177958_n() + 0.5f);
                    float y = ((float)this.func_174877_v().func_177956_o() + 0.875f) * coeff + (1.0f - coeff) * ((float)pedestal.func_174877_v().func_177956_o() + 1.0f);
                    float z = ((float)this.func_174877_v().func_177952_p() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestal.func_174877_v().func_177952_p() + 0.5f);
                    ParticleUtil.spawnParticleGlow(this.func_145831_w(), x, y, z, 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 2.0f, 24);
                }
            }
            if (this.angle % 10 == 0) {
                if (this.getNearbyAsh(pedestals) > 0) {
                    TileEntityAlchemyPedestal pedestal = pedestals.get(this.random.nextInt(pedestals.size()));
                    while (pedestal.inventory.extractItem(0, 1, true).func_190926_b()) {
                        pedestal = pedestals.get(this.random.nextInt(pedestals.size()));
                    }
                    if (!pedestal.inventory.getStackInSlot(1).func_190926_b()) {
                        if (this.func_145831_w().field_72995_K) {
                            for (int j = 0; j < 20; ++j) {
                                float dx = (float)this.func_174877_v().func_177958_n() + 0.5f - ((float)pedestal.func_174877_v().func_177958_n() + 0.5f);
                                float dy = (float)this.func_174877_v().func_177956_o() + 0.875f - ((float)pedestal.func_174877_v().func_177956_o() + 1.0f);
                                float dz = (float)this.func_174877_v().func_177952_p() + 0.5f - ((float)pedestal.func_174877_v().func_177952_p() + 0.5f);
                                float lifetime = this.random.nextFloat() * 24.0f + 24.0f;
                                ParticleUtil.spawnParticleStar(this.func_145831_w(), (float)pedestal.func_174877_v().func_177958_n() + 0.5f, (float)pedestal.func_174877_v().func_177956_o() + 1.0f, (float)pedestal.func_174877_v().func_177952_p() + 0.5f, dx / lifetime, dy / lifetime, dz / lifetime, 255.0f, 64.0f, 16.0f, 4.0f, (int)lifetime);
                            }
                        }
                        pedestal.inventory.extractItem(0, 1, false);
                        this.aspects.addAspect(AlchemyUtil.getAspect(pedestal.inventory.getStackInSlot(1)), 1);
                        this.func_70296_d();
                        pedestal.func_70296_d();
                    }
                } else {
                    AlchemyRecipe recipe = this.getRecipe();
                    if (recipe != null && !this.func_145831_w().field_72995_K) {
                        AlchemyResult result = recipe.matchAshes(this.aspects, this.field_145850_b);
                        ItemStack failure = recipe.isFailure(result) ? result.createFailure() : ItemStack.field_190927_a;
                        AlchemyResultEvent event = new AlchemyResultEvent(this, result, true, recipe.isFailure(result), failure);
                        UpgradeUtil.throwEvent(this, event, upgrades);
                        ItemStack stack = event.isFailure() ? event.getFailureStack() : recipe.getResult(this);
                        SoundEvent finishSound = event.isFailure() ? SoundManager.ALCHEMY_FAIL : SoundManager.ALCHEMY_SUCCESS;
                        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, finishSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)((float)this.func_174877_v().func_177956_o() + 1.0f), (double)this.func_174877_v().func_177952_p() + 0.5, stack));
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSphereFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5));
                        this.progress = 0;
                        if (event.shouldConsumeIngredients()) {
                            this.center.setStackInSlot(0, this.decrStack(this.center.getStackInSlot(0)));
                            this.north.setStackInSlot(0, this.decrStack(this.north.getStackInSlot(0)));
                            this.south.setStackInSlot(0, this.decrStack(this.south.getStackInSlot(0)));
                            this.east.setStackInSlot(0, this.decrStack(this.east.getStackInSlot(0)));
                            this.west.setStackInSlot(0, this.decrStack(this.west.getStackInSlot(0)));
                        }
                        this.func_70296_d();
                    }
                }
            }
        }
        if (this.progress == 0 && this.process > 0) {
            --this.process;
        }
    }

    public ItemStack decrStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.ALCHEMY_LOOP, SoundCategory.BLOCKS, true, 1.5f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.progress > 0;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            String filter = null;
            switch (facing) {
                case NORTH: {
                    filter = "embers.tooltip.side.north";
                    break;
                }
                case SOUTH: {
                    filter = "embers.tooltip.side.south";
                    break;
                }
                case EAST: {
                    filter = "embers.tooltip.side.east";
                    break;
                }
                case WEST: {
                    filter = "embers.tooltip.side.west";
                    break;
                }
                case DOWN: 
                case UP: {
                    filter = "embers.tooltip.side.center";
                }
            }
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.BOTH, "embers.tooltip.goggles.item", I18n.func_135052_a((String)filter, (Object[])new Object[0])));
        }
    }
}

