/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IItemPipeConnectable;
import teamroots.embers.tileentity.IItemPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityItemPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IItemPipeConnectable,
IItemPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.field_82609_l.length];
    boolean clogged = false;
    public ItemStackHandler inventory;
    EnumFacing lastTransfer;
    boolean syncInventory;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityItemPipeBase() {
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return TileEntityItemPipeBase.this.getCapacity();
            }

            protected void onContentsChanged(int slot) {
                TileEntityItemPipeBase.this.func_70296_d();
            }
        };
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.func_176745_a()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.func_176745_a()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) instanceof TileEntityItemPipeBase) || ((TileEntityItemPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksExisted;
            boolean itemsMoved = false;
            ItemStack passStack = this.inventory.extractItem(0, 1, true);
            if (!passStack.func_190926_b()) {
                IItemHandler handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                IItemHandler[] itemHandlers = new IItemHandler[EnumFacing.field_82609_l.length];
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
                    handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    int priority = 0;
                    if (tile instanceof IItemPipePriority) {
                        priority = ((IItemPipePriority)tile).getPriority(facing.func_176734_d());
                    }
                    if (this.isFrom(facing.func_176734_d())) {
                        priority -= 5;
                    }
                    possibleDirections.put(priority, facing);
                    itemHandlers[facing.func_176745_a()] = handler;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = itemHandlers[facing.func_176745_a()];
                        itemsMoved = this.pushStack(passStack, facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.func_70296_d();
                        }
                        if (!itemsMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!itemsMoved) continue;
                    break;
                }
            }
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                if (this.lastTransfer != null && !itemsMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.func_70296_d();
                }
                itemsMoved = true;
                this.resetFrom();
            }
            if (this.clogged == itemsMoved) {
                this.clogged = !itemsMoved;
                this.syncCloggedFlag = true;
                this.func_70296_d();
            }
        } else if (Embers.proxy.isPlayerWearingGoggles() && this.lastTransfer != null) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.func_82601_c() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.func_96559_d() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.func_82599_e() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.field_174879_c.func_177958_n() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82601_c() * dist;
                float y = (float)this.field_174879_c.func_177956_o() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_96559_d() * dist;
                float z = (float)this.field_174879_c.func_177952_p() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82599_e() * dist;
                float r = this.clogged ? 255.0f : 16.0f;
                float g = this.clogged ? 16.0f : 255.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.field_145850_b, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(ItemStack passStack, EnumFacing facing, IItemHandler handler) {
        ItemStack added;
        int slot = -1;
        for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
            if (!handler.insertItem(j, passStack, true).func_190926_b()) continue;
            slot = j;
        }
        if (slot != -1 && (added = handler.insertItem(slot, passStack, false)).func_190926_b()) {
            this.inventory.extractItem(0, 1, false);
            return true;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncInventory = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncInventory || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncInventory) {
            this.writeInventory(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeInventory(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            tag.func_74757_a("from" + facing.func_176745_a(), this.from[facing.func_176745_a()]);
        }
        tag.func_74768_a("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.func_74757_a("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.func_74768_a("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writeInventory(NBTTagCompound tag) {
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("clogged")) {
            this.clogged = tag.func_74767_n("clogged");
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        }
        if (tag.func_74764_b("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.func_74762_e("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!tag.func_74764_b("from" + facing.func_176745_a())) continue;
            this.from[facing.func_176745_a()] = tag.func_74767_n("from" + facing.func_176745_a());
        }
        if (tag.func_74764_b("lastRobin")) {
            this.lastRobin = tag.func_74762_e("lastRobin");
        }
    }
}

