/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.upgrade;

import java.text.DecimalFormat;
import java.util.List;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.tileentity.TileEntity;
import teamroots.embers.Embers;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeActuator
extends DefaultUpgradeProvider {
    public UpgradeActuator(TileEntity tile) {
        super("actuator", tile);
    }

    @Override
    public int getLimit(TileEntity tile) {
        return tile instanceof IMechanicallyPowered ? 1 : 0;
    }

    @Override
    public double getSpeed(TileEntity tile, double speed) {
        IMechanicallyPowered mechTile;
        double power = this.getPower();
        if (tile instanceof IMechanicallyPowered && power > (mechTile = (IMechanicallyPowered)tile).getMinimumPower() && power <= mechTile.getMaximumPower()) {
            return mechTile.getMechanicalSpeed(power) * speed;
        }
        return speed;
    }

    @Override
    public double transformEmberConsumption(TileEntity tile, double ember) {
        if (tile instanceof IMechanicallyPowered) {
            return ((IMechanicallyPowered)tile).getStandardPowerRatio() * ember;
        }
        return ember;
    }

    @Override
    public double getOtherParameter(TileEntity tile, String type, double value) {
        if (tile instanceof IMechanicallyPowered && type.equals("fuel_consumption")) {
            return ((IMechanicallyPowered)tile).getStandardPowerRatio() * value;
        }
        return value;
    }

    @Override
    public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        IMechanicallyPowered mechTile;
        double power = this.getPower();
        return !(power > (mechTile = (IMechanicallyPowered)tile).getMinimumPower()) || !(power <= mechTile.getMaximumPower());
    }

    @Override
    public void throwEvent(TileEntity tile, UpgradeEvent event) {
        DialInformationEvent dialEvent;
        IMechanicallyPowered mechTile = (IMechanicallyPowered)tile;
        if (event instanceof DialInformationEvent && "ember".equals((dialEvent = (DialInformationEvent)event).getDialType())) {
            DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.mechanical_multiplier");
            double power = this.getPower();
            double speedModifier = mechTile.getMechanicalSpeed(power) / mechTile.getNominalSpeed();
            dialEvent.getInformation().add(Embers.proxy.formatLocalize("embers.tooltip.upgrade.actuator", multiplierFormat.format(speedModifier)));
        }
    }

    private double getPower() {
        if (!this.tile.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, null)) {
            return 0.0;
        }
        IMechCapability handler = (IMechCapability)this.tile.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, null);
        return handler.getPower(null);
    }
}

