/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.chunkloader;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.utils.Log;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileTeleportTether
extends TileEntity {
    private ForgeChunkManager.Ticket chunkTicket;
    private int loadDistance = 1;

    public List<ChunkPos> getLoadArea() {
        LinkedList<ChunkPos> loadArea = new LinkedList<ChunkPos>();
        for (int x = -this.loadDistance; x < this.loadDistance + 1; ++x) {
            for (int z = -this.loadDistance; z < this.loadDistance + 1; ++z) {
                ChunkPos chunkCoords = new ChunkPos((this.field_174879_c.func_177958_n() >> 4) + x, (this.field_174879_c.func_177952_p() >> 4) + z);
                loadArea.add(chunkCoords);
            }
        }
        return loadArea;
    }

    public void func_145829_t() {
        ForgeChunkManager.Ticket ticket;
        super.func_145829_t();
        if (!this.func_145831_w().field_72995_K && this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)AdditionalPipes.instance, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.forceChunkLoading(ticket);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.stopChunkLoading();
    }

    public void setLoadDistance(int dist) {
        this.loadDistance = dist;
        this.forceChunkLoading(this.chunkTicket);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.stopChunkLoading();
        this.chunkTicket = ticket;
        for (ChunkPos coord : this.getLoadArea()) {
            Log.info(String.format("Teleport Tether @ %s: Force loading chunk %s in %s", this.func_174877_v().toString(), coord, this.func_145831_w().field_73011_w.getClass()));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)coord);
        }
    }

    public void unforceChunkLoading() {
        for (Object obj : this.chunkTicket.getChunkList()) {
            ChunkPos coord = (ChunkPos)obj;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)coord);
        }
    }

    public void stopChunkLoading() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        return super.func_189515_b(par1NBTTagCompound);
    }
}

