/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.lib.misc.EntityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PipeBehaviorDistribution
extends APPipe {
    public int[] distData = new int[]{1, 1, 1, 1, 1, 1};
    public EnumFacing distSide = EnumFacing.UP;
    public int itemsThisSide = Integer.MAX_VALUE;

    public PipeBehaviorDistribution(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.itemsThisSide = nbt.func_74762_e("itemsThisSide");
        this.distSide = EnumFacing.field_82609_l[nbt.func_74762_e("distSide")];
        for (int i = 0; i < this.distData.length; ++i) {
            this.distData[i] = nbt.func_74762_e("distData" + i);
        }
        this.sanityCheck();
    }

    public PipeBehaviorDistribution(IPipe pipe) {
        super(pipe);
    }

    public int getTextureIndex(EnumFacing connection) {
        if (connection == null) {
            return EnumFacing.EAST.ordinal();
        }
        return connection.ordinal();
    }

    @PipeEventHandler
    public void splitStacks(PipeEventItem.Split splitEvent) {
        ArrayList<PipeEventItem.ItemEntry> newDistribution = new ArrayList<PipeEventItem.ItemEntry>();
        for (PipeEventItem.ItemEntry entry : splitEvent.items) {
            Log.debug("[PipeDistribution] current side: " + this.distSide.func_176610_l() + " items left this side: " + this.getItemsLeftThisSide());
            if (entry.to == null) {
                entry.to = new ArrayList();
            }
            if (this.getItemsLeftThisSide() > 0 && entry.stack.func_190916_E() <= this.getItemsLeftThisSide()) {
                entry.to.clear();
                entry.to.add(this.distSide);
                this.itemsThisSide += entry.stack.func_190916_E();
                newDistribution.add(entry);
                continue;
            }
            while (entry.stack.func_190916_E() > 0) {
                if (this.getItemsLeftThisSide() <= 0) {
                    this.toNextOpenSide();
                }
                PipeEventItem.ItemEntry stackPartThisSide = new PipeEventItem.ItemEntry(null, entry.stack.func_77946_l(), entry.from);
                stackPartThisSide.to = new ArrayList();
                stackPartThisSide.stack.func_190920_e(Math.min(this.getItemsLeftThisSide(), entry.stack.func_190916_E()));
                entry.stack.func_190920_e(entry.stack.func_190916_E() - stackPartThisSide.stack.func_190916_E());
                newDistribution.add(stackPartThisSide);
                this.itemsThisSide += stackPartThisSide.stack.func_190916_E();
                stackPartThisSide.to.add(this.distSide);
            }
        }
        splitEvent.items.clear();
        splitEvent.items.addAll(newDistribution);
    }

    private void toNextOpenSide() {
        EnumFacing lastDistSide = this.distSide;
        this.itemsThisSide = 0;
        for (int o = 0; o < this.distData.length; ++o) {
            this.distSide = EnumFacing.field_82609_l[(this.distSide.ordinal() + 1) % this.distData.length];
            if (this.distData[this.distSide.ordinal()] <= 0 || !this.pipe.isConnected(this.distSide)) continue;
            Log.debug("toNextOpenSide(): distSide changed: " + lastDistSide + "-> " + this.distSide);
            return;
        }
    }

    private int getItemsLeftThisSide() {
        if (!this.pipe.isConnected(this.distSide)) {
            return 0;
        }
        return this.distData[this.distSide.ordinal()] - this.itemsThisSide;
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (!player.field_70170_p.field_72995_K) {
            this.pipe.getHolder().scheduleNetworkUpdate(new IPipeHolder.PipeMessageReceiver[]{IPipeHolder.PipeMessageReceiver.BEHAVIOUR});
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 2, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    private void sanityCheck() {
        for (int d : this.distData) {
            if (d <= 0) continue;
            return;
        }
        for (int i = 0; i < this.distData.length; ++i) {
            Arrays.fill(this.distData, 1);
        }
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("itemsThisSide", this.itemsThisSide);
        nbt.func_74768_a("distSide", this.distSide.ordinal());
        for (int i = 0; i < this.distData.length; ++i) {
            nbt.func_74768_a("distData" + i, this.distData[i]);
        }
        return nbt;
    }

    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            buffer.writeInt(this.itemsThisSide);
            buffer.writeInt(this.distSide.ordinal());
            for (int i = 0; i < this.distData.length; ++i) {
                buffer.writeInt(this.distData[i]);
            }
        }
    }

    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            this.itemsThisSide = buffer.readInt();
            this.distSide = EnumFacing.values()[buffer.readInt()];
            for (int i = 0; i < this.distData.length; ++i) {
                this.distData[i] = buffer.readInt();
            }
        }
    }
}

