/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.utils;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtils {
    public static int getFirstFreeSlot(IInventory inventory) {
        int size = inventory.func_70302_i_() - 1;
        for (int index = 0; index <= size; ++index) {
            if (inventory.func_70301_a(index) != null) continue;
            return index;
        }
        return -1;
    }

    public static boolean canItemFit(IInventory inventory, ItemStack stack) {
        int size = inventory.func_70302_i_() - 1;
        int stackLimit = inventory.func_70297_j_();
        int itemsLeftToAdd = stack.func_190916_E();
        for (int index = 0; index <= size; ++index) {
            ItemStack slotStack = inventory.func_70301_a(index);
            if (slotStack == null) {
                return true;
            }
            if (slotStack.func_77973_b() != stack.func_77973_b() || slotStack.func_77952_i() != stack.func_77952_i()) continue;
            if (slotStack.func_190916_E() + itemsLeftToAdd <= stackLimit) {
                return true;
            }
            itemsLeftToAdd -= stackLimit - slotStack.func_190916_E();
        }
        return false;
    }

    public static boolean containsItem(boolean matchMeta, boolean matchNBT, ItemStack stack, IItemHandler inventory) {
        int size = inventory.getSlots() - 1;
        for (int index = 0; index <= size; ++index) {
            ItemStack slotStack = inventory.getStackInSlot(index);
            if (slotStack == null || slotStack.func_77973_b() != stack.func_77973_b() || matchMeta && stack.func_77952_i() != slotStack.func_77952_i()) continue;
            if (!matchNBT || !slotStack.func_77942_o() && !stack.func_77942_o()) {
                return true;
            }
            if (!slotStack.func_77942_o() || !stack.func_77942_o() || !slotStack.func_77978_p().equals((Object)stack.func_77978_p())) continue;
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> getItems(IItemHandler handler) {
        int invSize = handler.getSlots();
        NonNullList stacks = NonNullList.func_191196_a();
        for (int index = 0; index < invSize; ++index) {
            ItemStack stack = handler.getStackInSlot(index);
            if (stack == null) continue;
            stacks.add((Object)stack);
        }
        return stacks;
    }
}

