/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.MjAPI;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.craft.IAutoCraft;
import buildcraft.lib.tile.craft.WorkbenchCrafting;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.silicon.tile.TileLaserTableBase;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileAdvancedCraftingTable
extends TileLaserTableBase
implements IAutoCraft {
    private static final long POWER_REQ = 500L * MjAPI.MJ;
    public final ItemHandlerSimple invBlueprint;
    public final ItemHandlerSimple invMaterials;
    public final ItemHandlerSimple invResults;
    private final WorkbenchCrafting crafting;
    public ItemStack resultClient = ItemStack.field_190927_a;

    public TileAdvancedCraftingTable() {
        this.invBlueprint = this.itemManager.addInvHandler("blueprint", 9, ItemHandlerManager.EnumAccess.PHANTOM, new EnumPipePart[0]);
        this.invMaterials = this.itemManager.addInvHandler("materials", 15, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invResults = this.itemManager.addInvHandler("result", 9, ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.crafting = new WorkbenchCrafting(3, 3, (TileBC_Neptune)this, this.invBlueprint, this.invMaterials, this.invResults);
    }

    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        super.onSlotChange(handler, slot, before, after);
        if (!ItemStack.func_77989_b((ItemStack)before, (ItemStack)after)) {
            this.crafting.onInventoryChange((IItemHandler)handler);
        }
    }

    @Override
    public long getTarget() {
        return this.field_145850_b.field_72995_K ? POWER_REQ : (this.crafting.canCraft() ? POWER_REQ : 0L);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean didChange = this.crafting.tick();
        if (this.crafting.canCraft() && this.power >= POWER_REQ && this.crafting.craft()) {
            this.power -= POWER_REQ;
        }
        if (didChange) {
            this.sendNetworkGuiUpdate(NET_GUI_DATA);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_GUI_DATA) {
            this.resultClient = buffer.func_150791_c();
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_GUI_DATA) {
            buffer.func_150788_a(this.crafting.getAssumedResult());
        }
    }

    public InventoryCrafting getWorkbenchCrafting() {
        return this.crafting;
    }

    public ItemStack getCurrentRecipeOutput() {
        return this.crafting.getAssumedResult();
    }

    public ItemHandlerSimple getInvBlueprint() {
        return this.invBlueprint;
    }
}

