/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.silicon.EnumAssemblyRecipeState;
import buildcraft.silicon.tile.TileLaserTableBase;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileAssemblyTable
extends TileLaserTableBase {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("assembly_table");
    public static final int NET_RECIPE_STATE = IDS.allocId("RECIPE_STATE");
    public final ItemHandlerSimple inv;
    public SortedMap<AssemblyInstruction, EnumAssemblyRecipeState> recipesStates;
    private static final ResourceLocation ADVANCEMENT = new ResourceLocation("buildcraftsilicon:precision_crafting");

    public TileAssemblyTable() {
        this.inv = this.itemManager.addInvHandler("inv", 12, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.recipesStates = new TreeMap<AssemblyInstruction, EnumAssemblyRecipeState>();
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    private void updateRecipes() {
        int count = this.recipesStates.size();
        for (AssemblyRecipe recipe : AssemblyRecipeRegistry.REGISTRY.values()) {
            Set outputs = recipe.getOutputs(this.inv.stacks);
            for (ItemStack out : outputs) {
                boolean found = false;
                for (AssemblyInstruction instruction : this.recipesStates.keySet()) {
                    if (instruction.recipe != recipe || out != instruction.output) continue;
                    found = true;
                    break;
                }
                AssemblyInstruction instruction = new AssemblyInstruction(recipe, out);
                if (found || this.recipesStates.containsKey(instruction)) continue;
                this.recipesStates.put(instruction, EnumAssemblyRecipeState.POSSIBLE);
            }
        }
        boolean findActive = false;
        Iterator<Map.Entry<AssemblyInstruction, EnumAssemblyRecipeState>> iterator = this.recipesStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AssemblyInstruction, EnumAssemblyRecipeState> entry = iterator.next();
            AssemblyInstruction instruction = entry.getKey();
            EnumAssemblyRecipeState state = entry.getValue();
            boolean enough = this.extract(this.inv, instruction.recipe.getInputsFor(instruction.output), true, false);
            if (state == EnumAssemblyRecipeState.POSSIBLE) {
                if (!enough) {
                    iterator.remove();
                }
            } else if (enough) {
                if (state == EnumAssemblyRecipeState.SAVED) {
                    state = EnumAssemblyRecipeState.SAVED_ENOUGH;
                }
            } else if (state != EnumAssemblyRecipeState.SAVED) {
                state = EnumAssemblyRecipeState.SAVED;
            }
            if (state == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) {
                findActive = true;
            }
            entry.setValue(state);
        }
        if (!findActive) {
            for (Map.Entry<AssemblyInstruction, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                EnumAssemblyRecipeState state = entry.getValue();
                if (state != EnumAssemblyRecipeState.SAVED_ENOUGH) continue;
                state = EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE;
                entry.setValue(state);
                break;
            }
        }
        if (count != this.recipesStates.size()) {
            this.sendNetworkGuiUpdate(NET_GUI_DATA);
        }
    }

    private AssemblyInstruction getActiveRecipe() {
        return this.recipesStates.entrySet().stream().filter(entry -> entry.getValue() == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private void activateNextRecipe() {
        AssemblyInstruction activeRecipe = this.getActiveRecipe();
        if (activeRecipe != null) {
            int index = 0;
            int activeIndex = 0;
            boolean isActiveLast = false;
            long enoughCount = this.recipesStates.values().stream().filter(state -> state == EnumAssemblyRecipeState.SAVED_ENOUGH || state == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE).count();
            if (enoughCount <= 1L) {
                return;
            }
            for (Map.Entry<AssemblyInstruction, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                EnumAssemblyRecipeState state2 = entry.getValue();
                if (state2 == EnumAssemblyRecipeState.SAVED_ENOUGH) {
                    isActiveLast = false;
                }
                if (state2 == EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE) {
                    state2 = EnumAssemblyRecipeState.SAVED_ENOUGH;
                    entry.setValue(state2);
                    activeIndex = index;
                    isActiveLast = true;
                }
                ++index;
            }
            index = 0;
            for (Map.Entry<AssemblyInstruction, EnumAssemblyRecipeState> entry : this.recipesStates.entrySet()) {
                AssemblyRecipe recipe = entry.getKey().recipe;
                EnumAssemblyRecipeState state3 = entry.getValue();
                if (state3 == EnumAssemblyRecipeState.SAVED_ENOUGH && recipe != activeRecipe.recipe && (index > activeIndex || isActiveLast)) {
                    state3 = EnumAssemblyRecipeState.SAVED_ENOUGH_ACTIVE;
                    entry.setValue(state3);
                    break;
                }
                ++index;
            }
        }
    }

    @Override
    public long getTarget() {
        return Optional.ofNullable(this.getActiveRecipe()).map(instruction -> instruction.recipe.getRequiredMicroJoulesFor(instruction.output)).orElse(0L);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateRecipes();
        if (this.getTarget() > 0L) {
            AdvancementUtil.unlockAdvancement((UUID)this.getOwner().getId(), (ResourceLocation)ADVANCEMENT);
            if (this.power >= this.getTarget()) {
                AssemblyInstruction instruction = this.getActiveRecipe();
                this.extract(this.inv, instruction.recipe.getInputsFor(instruction.output), false, false);
                InventoryUtil.addToBestAcceptor((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), null, (ItemStack)instruction.output.func_77946_l());
                this.power -= this.getTarget();
                this.activateNextRecipe();
            }
            this.sendNetworkGuiUpdate(NET_GUI_DATA);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList recipesStatesTag = new NBTTagList();
        this.recipesStates.forEach((instruction, state) -> {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("recipe", instruction.recipe.getRegistryName().toString());
            entryTag.func_74782_a("output", (NBTBase)instruction.output.serializeNBT());
            entryTag.func_74768_a("state", state.ordinal());
            recipesStatesTag.func_74742_a((NBTBase)entryTag);
        });
        nbt.func_74782_a("recipes_states", (NBTBase)recipesStatesTag);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recipesStates.clear();
        NBTTagList recipesStatesTag = nbt.func_150295_c("recipes_states", 10);
        for (int i = 0; i < recipesStatesTag.func_74745_c(); ++i) {
            AssemblyInstruction instruction;
            NBTTagCompound entryTag = recipesStatesTag.func_150305_b(i);
            String name = entryTag.func_74779_i("recipe");
            if (!entryTag.func_74764_b("output") || (instruction = this.lookupRecipe(name, new ItemStack(entryTag.func_74775_l("output")))) == null) continue;
            this.recipesStates.put(instruction, EnumAssemblyRecipeState.values()[entryTag.func_74762_e("state")]);
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (id == NET_GUI_DATA) {
            buffer.writeInt(this.recipesStates.size());
            this.recipesStates.forEach((instruction, state) -> {
                buffer.func_180714_a(instruction.recipe.getRegistryName().toString());
                buffer.func_150788_a(instruction.output);
                buffer.writeInt(state.ordinal());
            });
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (id == NET_GUI_DATA) {
            this.recipesStates.clear();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                AssemblyInstruction instruction = this.lookupRecipe(buffer.readString(), buffer.func_150791_c());
                this.recipesStates.put(instruction, EnumAssemblyRecipeState.values()[buffer.readInt()]);
            }
        }
        if (id == NET_RECIPE_STATE) {
            AssemblyInstruction recipe = this.lookupRecipe(buffer.readString(), buffer.func_150791_c());
            EnumAssemblyRecipeState state = EnumAssemblyRecipeState.values()[buffer.readInt()];
            if (this.recipesStates.containsKey(recipe)) {
                this.recipesStates.put(recipe, state);
            }
        }
    }

    public void sendRecipeStateToServer(AssemblyInstruction instruction, EnumAssemblyRecipeState state) {
        MessageUpdateTile message = this.createMessage(NET_RECIPE_STATE, buffer -> {
            buffer.func_180714_a(instruction.recipe.getRegistryName().toString());
            buffer.func_150788_a(instruction.output);
            buffer.writeInt(state.ordinal());
        });
        MessageManager.sendToServer((IMessage)message);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("recipes - " + this.recipesStates.size());
        left.add("target - " + LocaleUtil.localizeMj((long)this.getTarget()));
    }

    @Nullable
    private AssemblyInstruction lookupRecipe(String name, ItemStack output) {
        AssemblyRecipe recipe = (AssemblyRecipe)AssemblyRecipeRegistry.REGISTRY.get(new ResourceLocation(name));
        return recipe != null ? new AssemblyInstruction(recipe, output) : null;
    }

    public class AssemblyInstruction
    implements Comparable<AssemblyInstruction> {
        public final AssemblyRecipe recipe;
        public final ItemStack output;

        private AssemblyInstruction(AssemblyRecipe recipe, ItemStack output) {
            this.recipe = recipe;
            this.output = output;
        }

        @Override
        public int compareTo(AssemblyInstruction o) {
            return this.recipe.compareTo(o.recipe) + this.output.serializeNBT().toString().compareTo(o.output.serializeNBT().toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AssemblyInstruction)) {
                return false;
            }
            AssemblyInstruction instruction = (AssemblyInstruction)obj;
            return this.recipe.getRegistryName().equals((Object)instruction.recipe.getRegistryName()) && ItemStack.func_77989_b((ItemStack)this.output, (ItemStack)instruction.output);
        }
    }
}

