/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.blocks.BlockCompressed;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCompressedEntry
extends BlockEntry<BlockCompressed> {
    private final IBlockState blockState;
    private final String texture;
    private final int max;

    public BlockCompressedEntry(Block block, String texture, int max) {
        this(block.func_176223_P(), texture, max);
    }

    public BlockCompressedEntry(IBlockState blockState, String texture, int max) {
        super("Compressed" + StringHelper.capFirst(texture, true), new Class[0]);
        this.blockState = blockState;
        this.texture = texture;
        this.max = max;
    }

    @Override
    public BlockCompressed initValue() {
        return new BlockCompressed(this.blockState, this.texture, this.max);
    }

    @Override
    public void addRecipes() {
        ItemStack base = new ItemStack(this.blockState.func_177230_c());
        CraftingHelper.addShaped("compressed_" + this.texture, this.newStack(1, 0), "BBB", "BBB", "BBB", Character.valueOf('B'), base);
        CraftingHelper.addShapeless("compressed_" + this.texture + "_uncompress", new ItemStack(this.blockState.func_177230_c(), 9), this.newStack(1, 0));
        for (int i = 0; i < this.max - 1; ++i) {
            CraftingHelper.addShaped("compressed_" + this.texture + "_" + (i + 1), this.newStack(1, i + 1), "BBB", "BBB", "BBB", Character.valueOf('B'), this.newStack(1, i));
            CraftingHelper.addShapeless("compressed_" + this.texture + "_" + (i + 1) + "_uncompress", this.newStack(9, i), this.newStack(1, i + 1));
        }
    }

    @Override
    public void registerOres() {
        for (int i = 0; i < this.max; ++i) {
            OreDictionary.registerOre((String)("compressed" + (i + 1) + "x" + StringHelper.capFirst(this.texture, true)), (ItemStack)this.newStack(1, i));
        }
    }
}

