/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat;

import com.google.common.collect.Streams;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.fluids.TexturePlasma;
import com.rwtema.extrautils2.modcompat.MRISupplier;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public abstract class XUTinkerMaterial {
    @Nonnull
    public final Material material;
    @Nullable
    public final Fluid fluid;
    @Nonnull
    public final String name;
    public final int color;
    @Nullable
    public final String oreDicSuffix;
    @Nullable
    public final Supplier<ItemStack> representativeStack;
    private List<IMaterialStats> stats = new ArrayList<IMaterialStats>();
    private List<ITrait> allTraits = new ArrayList<ITrait>();
    private List<Pair<ITrait, String>> traits = new ArrayList<Pair<ITrait, String>>();

    public XUTinkerMaterial(final @Nonnull String name, int color, @Nullable String oreDicSuffix, @Nullable Supplier<ItemStack> representativeStack, boolean addFluid) {
        this.name = name;
        this.color = color;
        this.oreDicSuffix = oreDicSuffix;
        this.representativeStack = representativeStack;
        this.material = new Material(name, color);
        Lang.translate(String.format("material.%s.name", this.material.getIdentifier()), name);
        Lang.translate(String.format("material.%s.prefix", this.material.getIdentifier()), name);
        if (addFluid) {
            final ResourceLocation still = new ResourceLocation("extrautils2", name);
            ExtraUtils2.proxy.run(new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    Textures.registerSupplier(name, new Supplier<TextureAtlasSprite>(){

                        @Override
                        public TextureAtlasSprite get() {
                            int[] ints = XUTinkerMaterial.this.createPalette();
                            return new TexturePlasma(still.toString(), new ResourceLocation("extrautils2", "molten_fluid_base"), ints);
                        }
                    });
                }
            });
            this.fluid = new Fluid(name, still, still);
            this.fluid.setTemperature(1000);
            Lang.translate(this.fluid.getUnlocalizedName(), name);
        } else {
            this.fluid = null;
        }
        ExtraUtils2.proxy.run(new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                XUTinkerMaterial.this.material.setRenderInfo(XUTinkerMaterial.this.createRenderInfo());
            }
        });
        this.addStats(this.stats);
        this.addTraits();
    }

    public abstract void addTraits();

    public void addTrait(ITrait trait) {
        this.addTrait(trait, null);
    }

    public void addTraitToAllParts(ITrait trait) {
        this.allTraits.add(trait);
    }

    public void addTrait(ITrait trait, @Nullable String dependency) {
        this.traits.add((Pair<ITrait, String>)Pair.of((Object)trait, (Object)dependency));
    }

    protected int[] createPalette() {
        return new int[]{ColorHelper.multShade(this.color, 0.8f), this.color};
    }

    public abstract void addStats(List<IMaterialStats> var1);

    @SideOnly(value=Side.CLIENT)
    public final MaterialRenderInfo createRenderInfo() {
        return new MRISupplier(this.name, this);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite createTexture(ResourceLocation var1, String var2);

    public List<IMaterialStats> getStats() {
        return this.stats;
    }

    public Set<ITrait> getTraits() {
        return Streams.concat((Stream[])new Stream[]{this.traits.stream().map(Pair::getLeft), this.allTraits.stream()}).collect(Collectors.toSet());
    }

    public void registerTraits() {
        for (Pair<ITrait, String> trait : this.traits) {
            this.registerTrait((String)trait.getRight(), (ITrait)trait.getLeft());
        }
        for (String s : this.traits.stream().map(Pair::getRight).collect(Collectors.toSet())) {
            for (ITrait trait : this.allTraits) {
                this.registerTrait(s, trait);
            }
        }
    }

    private void registerTrait(String s, ITrait trait) {
        ITrait existingTrait = TinkerRegistry.getTrait((String)trait.getIdentifier());
        if (existingTrait != null) {
            trait = existingTrait;
        }
        this.material.addTrait(trait, s);
    }
}

