/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.gui.textures.TextureInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DrawableSprite
implements IDrawableStatic {
    private final TextureInfo info;

    public DrawableSprite(TextureInfo info) {
        this.info = info;
    }

    @Override
    public int getWidth() {
        return this.info.getWidth();
    }

    @Override
    public int getHeight() {
        return this.info.getHeight();
    }

    @Override
    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        this.draw(minecraft, xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(Minecraft minecraft, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        ResourceLocation location = this.info.getLocation();
        TextureAtlasSprite sprite = this.info.getSprite();
        int textureWidth = this.info.getWidth();
        int textureHeight = this.info.getHeight();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(location);
        int x = xOffset + (maskLeft += this.info.getTrimLeft());
        int y = yOffset + (maskTop += this.info.getTrimTop());
        int width = textureWidth - (maskRight += this.info.getTrimRight()) - maskLeft;
        int height = textureHeight - (maskBottom += this.info.getTrimBottom()) - maskTop;
        float uSize = sprite.func_94212_f() - sprite.func_94209_e();
        float vSize = sprite.func_94210_h() - sprite.func_94206_g();
        float minU = sprite.func_94209_e() + uSize * ((float)maskLeft / (float)textureWidth);
        float minV = sprite.func_94206_g() + vSize * ((float)maskTop / (float)textureHeight);
        float maxU = sprite.func_94212_f() - uSize * ((float)maskRight / (float)textureWidth);
        float maxV = sprite.func_94210_h() - vSize * ((float)maskBottom / (float)textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

