/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackVariant;
import gr8pefish.ironbackpacks.api.upgrade.BackpackUpgrade;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackInfo
implements INBTSerializable<NBTTagCompound> {
    public static final int NO_COLOR = -1;
    @Nonnull
    private final List<BackpackUpgrade> upgrades;
    @Nonnull
    private BackpackVariant backpackVariant;
    private IItemHandlerModifiable inventory;
    @Nullable
    private UUID owner;
    private int rgbColor;

    private BackpackInfo(@Nonnull BackpackVariant backpackVariant, @Nonnull List<BackpackUpgrade> upgrades) {
        Preconditions.checkNotNull((Object)backpackVariant, (Object)"Backpack variant cannot be null");
        Preconditions.checkNotNull(upgrades, (Object)"Upgrade list cannot be null");
        this.backpackVariant = backpackVariant;
        this.upgrades = upgrades;
        this.rgbColor = -1;
    }

    public BackpackInfo(@Nonnull BackpackVariant backpackVariant) {
        this(backpackVariant, Lists.newArrayList());
    }

    private BackpackInfo() {
        this(new BackpackVariant(IronBackpacksAPI.getBackpackType(IronBackpacksAPI.NULL), BackpackSpecialty.NONE), Lists.newArrayList());
    }

    @Nonnull
    public BackpackVariant getVariant() {
        return this.backpackVariant;
    }

    @Nonnull
    public BackpackInfo setVariant(@Nonnull BackpackVariant variant) {
        Preconditions.checkNotNull((Object)variant, (Object)"Backpack variant cannot be null");
        this.backpackVariant = variant;
        return this;
    }

    @Nonnull
    public List<BackpackUpgrade> getUpgrades() {
        return ImmutableList.copyOf(this.upgrades);
    }

    @Nonnull
    public BackpackInfo addUpgrade(@Nonnull BackpackUpgrade upgrade) {
        Preconditions.checkNotNull((Object)((Object)upgrade), (Object)"Upgrade cannot be null");
        this.upgrades.add(upgrade);
        return this;
    }

    @Nonnull
    public BackpackInfo removeUpgrade(@Nonnull BackpackUpgrade upgrade) {
        Preconditions.checkNotNull((Object)((Object)upgrade), (Object)"Upgrade cannot be null");
        this.upgrades.remove((Object)upgrade);
        return this;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public BackpackInfo setInventory(@Nonnull IItemHandlerModifiable inventory) {
        this.inventory = inventory;
        return this;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Nonnull
    public BackpackInfo setOwner(@Nullable UUID owner) {
        this.owner = owner;
        return this;
    }

    public boolean getIsColored() {
        return this.rgbColor != -1;
    }

    public int getRGBColor() {
        return this.rgbColor;
    }

    public BackpackInfo setRGBColor(int rgbColor) {
        this.rgbColor = rgbColor;
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", this.backpackVariant.getBackpackType().getIdentifier().toString());
        tag.func_74778_a("spec", this.backpackVariant.getBackpackSpecialty().name());
        if (this.owner != null) {
            tag.func_74778_a("own", this.owner.toString());
        }
        if (this.getIsColored()) {
            tag.func_74768_a("color", this.rgbColor);
        }
        NBTTagList installedUpgrades = new NBTTagList();
        for (BackpackUpgrade backpackUpgrade : this.upgrades) {
            installedUpgrades.func_74742_a((NBTBase)new NBTTagString(backpackUpgrade.getIdentifier().toString()));
        }
        tag.func_74782_a("upgrade", (NBTBase)installedUpgrades);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.backpackVariant = new BackpackVariant(IronBackpacksAPI.getBackpackType(new ResourceLocation(nbt.func_74779_i("type"))), BackpackSpecialty.getBackpackSpecialty(nbt.func_74779_i("spec")));
        if (nbt.func_74764_b("own")) {
            this.owner = UUID.fromString(nbt.func_74779_i("own"));
        }
        if (nbt.func_74764_b("color")) {
            this.rgbColor = nbt.func_74762_e("color");
        }
        NBTTagList installedUpgrades = nbt.func_150295_c("upgrade", 8);
        for (int i = 0; i < installedUpgrades.func_74745_c(); ++i) {
            ResourceLocation identifier = new ResourceLocation(installedUpgrades.func_150307_f(i));
            BackpackUpgrade backpackUpgrade = IronBackpacksAPI.getUpgrade(identifier);
            if (backpackUpgrade.isNull()) continue;
            this.upgrades.add(backpackUpgrade);
        }
    }

    public boolean conflicts(@Nullable BackpackUpgrade upgrade) {
        if (upgrade == null) {
            return false;
        }
        for (BackpackUpgrade installed : this.upgrades) {
            if (!upgrade.isConflicting(installed)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgrade(@Nullable BackpackUpgrade backpackUpgrade) {
        return this.upgrades.contains((Object)backpackUpgrade);
    }

    public int getPointsUsed() {
        int used = 0;
        for (BackpackUpgrade backpackUpgrade : this.upgrades) {
            used += backpackUpgrade.getApplicationCost();
        }
        return used;
    }

    public int getMaxPoints() {
        return this.backpackVariant.getBackpackType().getBaseMaxUpgradePoints() + (this.backpackVariant.getBackpackSpecialty() == BackpackSpecialty.UPGRADE ? 5 : 0);
    }

    @Nonnull
    public static BackpackInfo fromStack(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("packInfo")) {
            return new BackpackInfo();
        }
        BackpackInfo tagged = BackpackInfo.fromTag(stack.func_77978_p().func_74775_l("packInfo"));
        ItemStackHandler stackHandler = new ItemStackHandler(tagged.backpackVariant.getBackpackSize().getTotalSize());
        NBTTagList tagList = stack.func_77978_p().func_150295_c("packInv", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            stackHandler.setStackInSlot(i, new ItemStack(tagList.func_150305_b(i)));
        }
        return tagged.setInventory((IItemHandlerModifiable)stackHandler);
    }

    @Nonnull
    public static BackpackInfo fromTag(@Nullable NBTTagCompound tag) {
        BackpackInfo backpackInfo = new BackpackInfo();
        if (tag == null || tag.func_82582_d()) {
            return backpackInfo;
        }
        backpackInfo.deserializeNBT(tag);
        return backpackInfo;
    }

    @Nonnull
    public static BackpackInfo upgradeTo(@Nonnull BackpackInfo toUpgrade, @Nonnull BackpackType newType, @Nonnull BackpackSpecialty newSpecialty) {
        return new BackpackInfo(new BackpackVariant(newType, newSpecialty), toUpgrade.upgrades).setOwner(toUpgrade.getOwner()).setInventory(toUpgrade.inventory);
    }

    public static int getColor(@Nonnull ItemStack stack) {
        NBTTagCompound packInfo;
        NBTTagCompound compound;
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null");
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("packInfo") && (packInfo = compound.func_74775_l("packInfo")).func_74764_b("color")) {
            return packInfo.func_74762_e("color");
        }
        return -1;
    }
}

