/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemWaypointCompass;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class BlockMapFrame
extends BiblioWoodBlock {
    public static final String name = "MapFrame";
    public static final BlockMapFrame instance = new BlockMapFrame();

    public BlockMapFrame() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMapFrame frameTile = (TileEntityMapFrame)world.func_175625_s(pos);
        ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!world.field_72995_K && frameTile != null) {
            if (player.func_70093_af()) {
                frameTile.rotateMap();
                return true;
            }
            if (playerStack != ItemStack.field_190927_a) {
                if (playerStack.func_77973_b() == Items.field_151098_aY) {
                    int stackSize = playerStack.func_190916_E();
                    if (frameTile.addMap(playerStack)) {
                        if (stackSize == 1) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        } else {
                            playerStack.func_190920_e(--stackSize);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerStack);
                        }
                        return true;
                    }
                }
                if (playerStack.func_77973_b() instanceof ItemDrill) {
                    frameTile.removeStackFromInventoryFromWorld(0, player, this);
                    frameTile.removeMap();
                }
            }
        }
        if (world.field_72995_K) {
            if (player.func_70093_af()) {
                return true;
            }
            int faceCheck = frameTile.checkFace(frameTile.getAngle(), side, frameTile.getVertPosition());
            if (faceCheck != -1) {
                int[] coords;
                int pinPass = -1;
                switch (faceCheck) {
                    case 0: {
                        pinPass = frameTile.findPinCoords(hitX, hitY);
                        break;
                    }
                    case 1: {
                        pinPass = frameTile.findPinCoords(hitZ, hitY);
                        break;
                    }
                    case 2: {
                        pinPass = frameTile.findPinCoords(hitX, hitZ);
                    }
                }
                if (pinPass != -1 && (coords = frameTile.getWorldCoordsFromPin(pinPass)) != null) {
                    String pinName = frameTile.getPinName(pinPass);
                    player.func_145747_a((ITextComponent)new TextComponentString(pinName + "  @  X = " + coords[0] + "   Z = " + coords[1]));
                    if (playerStack != ItemStack.field_190927_a && playerStack.func_77973_b() instanceof ItemWaypointCompass) {
                        ItemWaypointCompass comp = (ItemWaypointCompass)playerStack.func_77973_b();
                        ItemStack updatedCompass = comp.writeNBT(playerStack, coords[0], coords[1], pinName);
                        try {
                            ByteBuf buffer = Unpooled.buffer();
                            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)updatedCompass);
                            BiblioCraft.ch_BiblioInvStack.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioUpdateInv"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMapFrame();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
        if (tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame frame = (TileEntityMapFrame)tile;
            modelParts = new ArrayList<String>();
            modelParts.add("main");
            if (!frame.getTopFrame()) {
                modelParts.add("borderTop");
            }
            if (!frame.getBottomFrame()) {
                modelParts.add("borderBottom");
            }
            if (!frame.getLeftFrame()) {
                modelParts.add("borderLeft");
            }
            if (!frame.getRightFrame()) {
                modelParts.add("borderRight");
            }
            if (!frame.getTopFrame() || !frame.getLeftFrame()) {
                modelParts.add("cornerTL");
            }
            if (!frame.getTopFrame() || !frame.getRightFrame()) {
                modelParts.add("cornerTR");
            }
            if (!frame.getBottomFrame() || !frame.getLeftFrame()) {
                modelParts.add("cornerBL");
            }
            if (!frame.getBottomFrame() || !frame.getRightFrame()) {
                modelParts.add("cornerBR");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        int pitch = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++pitch;
        if ((pitch %= 4) == 0) {
            biblioTile.setVertPosition(EnumVertPosition.CEILING);
            biblioTile.setAngle(EnumFacing.SOUTH);
        } else if (pitch == 1) {
            biblioTile.setVertPosition(EnumVertPosition.WALL);
        } else {
            biblioTile.setVertPosition(EnumVertPosition.FLOOR);
            biblioTile.setAngle(EnumFacing.SOUTH);
        }
        if (biblioTile instanceof TileEntityMapFrame) {
            TileEntityMapFrame frame = (TileEntityMapFrame)biblioTile;
            this.checkNeighborMapFrames(biblioTile.func_145831_w(), biblioTile.func_174877_v().func_177958_n(), biblioTile.func_174877_v().func_177956_o(), biblioTile.func_174877_v().func_177952_p(), frame);
            biblioTile.func_145831_w().func_184138_a(biblioTile.func_174877_v(), biblioTile.func_145831_w().func_180495_p(biblioTile.func_174877_v()), biblioTile.func_145831_w().func_180495_p(biblioTile.func_174877_v()), 3);
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        if (tile.getVertPosition() == EnumVertPosition.CEILING) {
            transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 1.0f, 0.0f), new Quat4f(0.0f, 0.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        } else if (tile.getVertPosition() == EnumVertPosition.FLOOR) {
            transform = transform.compose(new TRSRTransformation(new Vector3f(1.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        }
        return transform;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityMapFrame) {
            TileEntityMapFrame frameTile = (TileEntityMapFrame)tileEntity;
            EnumVertPosition vertAngleGet = frameTile.getVertPosition();
            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
            switch (frameTile.getAngle()) {
                case SOUTH: {
                    switch (vertAngleGet) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
                            break;
                        }
                        case WALL: {
                            output = this.getBlockBounds(0.95f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (vertAngleGet) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
                            break;
                        }
                        case WALL: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.95f, 1.0f, 1.0f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (vertAngleGet) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
                            break;
                        }
                        case WALL: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (vertAngleGet) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
                            break;
                        }
                        case WALL: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.05f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
                default: {
                    output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
                }
            }
        }
        return output;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame frameTile = (TileEntityMapFrame)tile;
            this.checkNeighborMapFrames(tile.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), frameTile);
            frameTile.func_145831_w().func_184138_a(frameTile.func_174877_v(), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), 3);
        }
    }

    public void checkNeighborMapFrames(World world, int i, int j, int k, TileEntityMapFrame mapFrame) {
        EnumVertPosition vertAngle = mapFrame.getVertPosition();
        EnumFacing angle = mapFrame.getAngle();
        if (vertAngle == EnumVertPosition.WALL) {
            int xLeftAdjust = 0;
            int zLeftAdjust = 0;
            int xRightAdjust = 0;
            int zRightAdjust = 0;
            switch (angle) {
                case SOUTH: {
                    --zLeftAdjust;
                    ++zRightAdjust;
                    break;
                }
                case WEST: {
                    ++xLeftAdjust;
                    --xRightAdjust;
                    break;
                }
                case NORTH: {
                    ++zLeftAdjust;
                    --zRightAdjust;
                    break;
                }
                case EAST: {
                    --xLeftAdjust;
                    ++xRightAdjust;
                    break;
                }
            }
            TileEntity blockUp = world.func_175625_s(new BlockPos(i, j + 1, k));
            TileEntity blockDown = world.func_175625_s(new BlockPos(i, j - 1, k));
            TileEntity blockLeft = world.func_175625_s(new BlockPos(i + xLeftAdjust, j, k + zLeftAdjust));
            TileEntity blockRight = world.func_175625_s(new BlockPos(i + xRightAdjust, j, k + zRightAdjust));
            if (this.isMapFrameBlock(blockUp)) {
                mapFrame.setTopFrame(true);
            } else {
                mapFrame.setTopFrame(false);
            }
            if (this.isMapFrameBlock(blockDown)) {
                mapFrame.setBottomFrame(true);
            } else {
                mapFrame.setBottomFrame(false);
            }
            if (this.isMapFrameBlock(blockLeft)) {
                mapFrame.setLeftFrame(true);
            } else {
                mapFrame.setLeftFrame(false);
            }
            if (this.isMapFrameBlock(blockRight)) {
                mapFrame.setRightFrame(true);
            } else {
                mapFrame.setRightFrame(false);
            }
        } else {
            int xTopAdjust = 0;
            int xBottomAdjust = 0;
            int xLeftAdjust = 0;
            int xRightAdjust = 0;
            int zTopAdjust = 0;
            int zBottomAdjust = 0;
            int zLeftAdjust = 0;
            int zRightAdjust = 0;
            if (vertAngle == EnumVertPosition.FLOOR) {
                ++xTopAdjust;
                --xBottomAdjust;
                --zLeftAdjust;
                ++zRightAdjust;
            } else {
                --xTopAdjust;
                ++xBottomAdjust;
                --zLeftAdjust;
                ++zRightAdjust;
            }
            TileEntity blockFront = world.func_175625_s(new BlockPos(i + xTopAdjust, j, k + zTopAdjust));
            TileEntity blockBack = world.func_175625_s(new BlockPos(i + xBottomAdjust, j, k + zBottomAdjust));
            TileEntity blockLeft = world.func_175625_s(new BlockPos(i + xLeftAdjust, j, k + zLeftAdjust));
            TileEntity blockRight = world.func_175625_s(new BlockPos(i + xRightAdjust, j, k + zRightAdjust));
            if (this.isMapFrameBlock(blockFront)) {
                mapFrame.setTopFrame(true);
            } else {
                mapFrame.setTopFrame(false);
            }
            if (this.isMapFrameBlock(blockBack)) {
                mapFrame.setBottomFrame(true);
            } else {
                mapFrame.setBottomFrame(false);
            }
            if (this.isMapFrameBlock(blockLeft)) {
                mapFrame.setLeftFrame(true);
            } else {
                mapFrame.setLeftFrame(false);
            }
            if (this.isMapFrameBlock(blockRight)) {
                mapFrame.setRightFrame(true);
            } else {
                mapFrame.setRightFrame(false);
            }
        }
    }

    public boolean isMapFrameBlock(TileEntity blockID) {
        return blockID != null && blockID instanceof TileEntityMapFrame;
    }
}

