/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackOreMatcher
extends ItemStackMatcher {
    private List<ItemStack> oreDictMatches;

    public ItemStackOreMatcher(@Nonnull ItemStack stack) {
        super(stack);
        this.refreshOreDictMatches();
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (!this.stack.func_77969_a(stack)) {
            if (this.oreDictMatches == null) {
                return false;
            }
            if (this.stack.func_77973_b() == stack.func_77973_b()) {
                return false;
            }
            boolean oreMatch = false;
            for (ItemStack oreDictMatch : this.oreDictMatches) {
                if (!stack.func_77969_a(oreDictMatch)) continue;
                oreMatch = true;
                break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)stack);
    }

    public void refreshOreDictMatches() {
        if (this.stack.func_190926_b()) {
            this.oreDictMatches = null;
            return;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)this.stack);
        if (oreIDs.length == 0) {
            this.oreDictMatches = null;
        } else {
            this.oreDictMatches = new ArrayList<ItemStack>();
            for (int id : oreIDs) {
                String oreName = OreDictionary.getOreName((int)id);
                if (!StorageDrawers.oreDictRegistry.isEntryValid(oreName)) continue;
                NonNullList list = OreDictionary.getOres((String)oreName);
                for (ItemStack aList : list) {
                    if (aList.func_77952_i() == Short.MAX_VALUE) continue;
                    this.oreDictMatches.add(aList);
                }
            }
            if (this.oreDictMatches.size() == 0) {
                this.oreDictMatches = null;
            }
        }
    }

    public static boolean areItemsEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return ItemStackOreMatcher.areItemsEqual(stack1, stack2, true);
    }

    public static boolean areItemsEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, boolean oreDictStrictMode) {
        if (!(stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77969_a(stack2))) {
            if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
                return false;
            }
            if (stack1.func_77973_b() == stack2.func_77973_b()) {
                return false;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length == 0 || ids2.length == 0) {
                return false;
            }
            boolean oreMatch = false;
            for (int id1 : ids1) {
                for (int id2 : ids2) {
                    if (id1 != id2) continue;
                    String name = OreDictionary.getOreName((int)id1);
                    if (oreDictStrictMode && !StorageDrawers.oreDictRegistry.isEntryValid(name)) continue;
                    oreMatch = true;
                    break;
                }
                if (oreMatch) break;
            }
            if (!oreMatch) {
                return false;
            }
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

