/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory.filter;

import buildcraft.api.core.IFluidFilter;
import buildcraft.lib.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ArrayFluidFilter
implements IFluidFilter {
    protected FluidStack[] fluids;

    public ArrayFluidFilter(ItemStack ... stacks) {
        this(StackUtil.listOf(stacks));
    }

    public ArrayFluidFilter(FluidStack ... iFluids) {
        this.fluids = iFluids;
    }

    public ArrayFluidFilter(NonNullList<ItemStack> stacks) {
        this.fluids = new FluidStack[stacks.size()];
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack stack = FluidUtil.getFluidContained((ItemStack)((ItemStack)stacks.get(i)));
            if (stack == null) continue;
            this.fluids[i] = stack;
        }
    }

    public boolean hasFilter() {
        for (FluidStack filter : this.fluids) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(FluidStack fluid) {
        for (FluidStack filter : this.fluids) {
            if (filter == null || !filter.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }
}

