/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderUtil {
    private static final ThreadLocal<TessellatorQueue> threadLocalTessellators = ThreadLocal.withInitial(TessellatorQueue::new);
    private static final MethodHandle HANDLE_FORGE_TESSELLATOR = RenderUtil.createGetter(TileEntityRendererDispatcher.class, Tessellator.class, "batchBuffer");
    private static final MethodHandle HANDLE_IS_BUFFER_DRAWING = RenderUtil.createGetter(BufferBuilder.class, Boolean.TYPE, "isDrawing", "field_179010_r");

    private static MethodHandle createGetter(Class<?> owner, Class<?> type, String ... names) {
        try {
            HashSet nameSet = new HashSet();
            Collections.addAll(nameSet, names);
            ArrayList<Field> validFields = new ArrayList<Field>();
            for (Field field : owner.getDeclaredFields()) {
                if (field.getType() != type || !nameSet.contains(field.getName())) continue;
                validFields.add(field);
            }
            if (validFields.size() != 1) {
                throw new Error("Incorrect number of fields! (Expected 1, but got " + validFields + ")");
            }
            Field fld = (Field)validFields.get(0);
            fld.setAccessible(true);
            return MethodHandles.publicLookup().unreflectGetter(fld);
        }
        catch (ReflectiveOperationException roe) {
            throw new Error("Failed to obtain forge's batch buffer!", roe);
        }
    }

    public static void registerBlockColour(@Nullable Block block, IBlockColor colour) {
        if (block != null) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(colour, new Block[]{block});
        }
    }

    public static void registerItemColour(@Nullable Item item, IItemColor colour) {
        if (item != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(colour, new Item[]{item});
        }
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
    }

    public static void setGLColorFromIntPlusAlpha(int color) {
        float alpha = (float)(color >>> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static int swapARGBforABGR(int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static boolean isRenderingTranslucent() {
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT || MinecraftForgeClient.getRenderPass() == 1;
    }

    public static boolean isMainRenderThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    public static AutoTessellator getThreadLocalUnusedTessellator() {
        return threadLocalTessellators.get().nextFreeTessellator();
    }

    public static Tessellator getMainTessellator() {
        if (!RenderUtil.isMainRenderThread()) {
            throw new IllegalStateException("Not the main thread!");
        }
        try {
            return HANDLE_FORGE_TESSELLATOR.invokeExact(TileEntityRendererDispatcher.field_147556_a);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static boolean isDrawing(BufferBuilder bb) {
        try {
            return HANDLE_IS_BUFFER_DRAWING.invokeExact(bb);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static Tessellator newTessellator() {
        return new Tessellator(0x200000);
    }

    public static final class AutoTessellator
    implements AutoCloseable {
        private final TessellatorQueue queue;
        private final int index;
        public final Tessellator tessellator;

        public AutoTessellator(TessellatorQueue queue, int index) {
            this.queue = queue;
            this.index = index;
            this.tessellator = queue.tessellators[index];
            queue.tessellatorInUse[index] = true;
        }

        @Override
        public void close() {
            this.queue.tessellatorInUse[this.index] = false;
        }
    }

    static class TessellatorQueue {
        private static final int BUFFER_COUNT = 20;
        final Tessellator[] tessellators = new Tessellator[20];
        final boolean[] tessellatorInUse = new boolean[20];

        TessellatorQueue() {
        }

        AutoTessellator nextFreeTessellator() {
            for (int i = 0; i < this.tessellators.length; ++i) {
                if (this.tessellatorInUse[i]) continue;
                Tessellator tess = this.tessellators[i];
                if (tess == null) {
                    this.tessellators[i] = tess = RenderUtil.newTessellator();
                }
                return new AutoTessellator(this, i);
            }
            throw new Error("Too many tessellators! Has a caller not finished with one of them?");
        }
    }
}

