/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.path;

import buildcraft.lib.path.MiniChunkCache;
import buildcraft.lib.path.task.TaskMiniChunkAnalyser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MiniChunkGraph {
    public final BlockPos min;
    public final ChunkType type;
    public final Map<EnumFacing, MiniChunkGraph> neighbours = new EnumMap<EnumFacing, MiniChunkGraph>(EnumFacing.class);
    public final ImmutableList<MiniChunkNode> nodes;
    final byte[][][] expenseArray;
    final byte[][][] graphArray;

    public MiniChunkGraph(BlockPos min, ChunkType type, byte[][][] expenseArray, byte[][][] graphArray, int numNodes) {
        this.min = min;
        this.type = type;
        this.expenseArray = expenseArray;
        this.graphArray = graphArray;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < numNodes; ++i) {
            builder.add((Object)new MiniChunkNode(i));
        }
        this.nodes = builder.build();
    }

    public MiniChunkNode getFor(BlockPos pos) {
        BlockPos normalised = pos.func_177973_b((Vec3i)this.min);
        if (!TaskMiniChunkAnalyser.isValid(normalised)) {
            throw new IllegalArgumentException("The position " + normalised + " was invalid! (from " + pos + ")");
        }
        byte id = this.graphArray[normalised.func_177958_n()][normalised.func_177956_o()][normalised.func_177952_p()];
        if (id >= 0) {
            return (MiniChunkNode)this.nodes.get((int)id);
        }
        throw new IllegalArgumentException("The position " + normalised + " had no graph! (gId = " + id + ")");
    }

    public class MiniChunkNode {
        public final int id;
        final Set<MiniChunkNode> connected = Sets.newIdentityHashSet();

        public MiniChunkNode(int id) {
            this.id = id;
        }

        public Set<MiniChunkNode> getConnected() {
            return Collections.unmodifiableSet(this.connected);
        }

        public boolean contains(BlockPos pos) {
            BlockPos normalised = pos.func_177973_b((Vec3i)MiniChunkGraph.this.min);
            if (!TaskMiniChunkAnalyser.isValid(normalised)) {
                return false;
            }
            return MiniChunkGraph.this.graphArray[normalised.func_177958_n()][normalised.func_177956_o()][normalised.func_177952_p()] == this.id;
        }

        public int getExpense(BlockPos pos) {
            BlockPos normalised = pos.func_177973_b((Vec3i)MiniChunkGraph.this.min);
            if (!TaskMiniChunkAnalyser.isValid(normalised)) {
                return Integer.MAX_VALUE;
            }
            byte expense = MiniChunkGraph.this.expenseArray[normalised.func_177958_n()][normalised.func_177956_o()][normalised.func_177952_p()];
            if (expense < 0) {
                return Integer.MAX_VALUE;
            }
            return expense;
        }

        public MiniChunkGraph getParent() {
            return MiniChunkGraph.this;
        }

        public void requestAllConnected(World world) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (MiniChunkGraph.this.neighbours.containsKey(face)) continue;
                MiniChunkCache.requestGraph(world, MiniChunkGraph.this.min.func_177967_a(face, 16));
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (MiniChunkGraph.this.neighbours.containsKey(face)) continue;
                MiniChunkCache.requestAndWait(world, MiniChunkGraph.this.min.func_177967_a(face, 16));
            }
        }
    }

    public static enum ChunkType {
        COMPLETELY_FREE,
        SINGLE_GRAPH,
        MULTIPLE_GRAPHS,
        COMPLETELY_FILLED;

    }
}

