/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import the_fireplace.grandeconomy.TextStyles;
import the_fireplace.grandeconomy.translation.TranslationUtil;

public class ChatPageUtil {
    public static void showPaginatedChat(ICommandSender sender, String command, List<ITextComponent> items, int page) {
        int resultsOnPage = 7;
        int current = page;
        int totalPageCount = items.size() % resultsOnPage > 0 ? items.size() / resultsOnPage + 1 : items.size() / resultsOnPage;
        ITextComponent counter = TranslationUtil.getTranslation(sender, "grandeconomy.chat.page.num", current, totalPageCount);
        ITextComponent top = new TextComponentString("-----------------").func_150255_a(TextStyles.GREEN).func_150257_a(counter).func_150258_a("-------------------").func_150255_a(TextStyles.GREEN);
        page *= resultsOnPage;
        page -= resultsOnPage;
        int termLength = resultsOnPage;
        ArrayList printItems = Lists.newArrayList();
        for (ITextComponent item : items) {
            if (page-- > 0) continue;
            if (termLength-- <= 0) break;
            printItems.add(item);
        }
        TextComponentString nextButton = current < totalPageCount ? TranslationUtil.getTranslation(sender, "grandeconomy.chat.page.next", new Object[0]).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(command, current + 1)))) : new TextComponentString("-----");
        TextComponentString prevButton = current > 1 ? TranslationUtil.getTranslation(sender, "grandeconomy.chat.page.prev", new Object[0]).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(command, current - 1)))) : new TextComponentString("------");
        ITextComponent bottom = new TextComponentString("---------------").func_150255_a(TextStyles.GREEN).func_150257_a((ITextComponent)prevButton).func_150258_a("---").func_150255_a(TextStyles.GREEN).func_150257_a((ITextComponent)nextButton).func_150258_a("-------------").func_150255_a(TextStyles.GREEN);
        sender.func_145747_a(top);
        for (ITextComponent item : printItems) {
            sender.func_145747_a(item);
        }
        sender.func_145747_a(bottom);
    }

    public static void showPaginatedChat(ICommandSender target, String command, List<ITextComponent> items) {
        ChatPageUtil.showPaginatedChat(target, command, items, 1);
    }
}

