/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import the_fireplace.grandeconomy.api.GrandEconomyApi;
import the_fireplace.grandeconomy.econhandlers.ge.InsufficientCreditException;
import the_fireplace.grandeconomy.translation.TranslationUtil;

public class CommandPay
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "pay";
    }

    @Nonnull
    public String func_71518_a(@Nullable ICommandSender sender) {
        return TranslationUtil.getRawTranslationString(sender, "commands.grandeconomy.pay.usage");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length <= 2) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException(TranslationUtil.getStringTranslation("commands.grandeconomy.common.console", this.func_71518_a(sender)), new Object[0]);
        EntityPlayerMP targetPlayer = CommandPay.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        GrandEconomyApi.ensureAccountExists(targetPlayer.func_110124_au());
        long amount = CommandPay.func_175766_b((String)args[1]);
        if (amount < 0L) {
            throw new NumberInvalidException(TranslationUtil.getStringTranslation(((EntityPlayerMP)sender).func_110124_au(), "commands.grandeconomy.pay.negative", new Object[0]), new Object[0]);
        }
        if (GrandEconomyApi.getBalance(((EntityPlayerMP)sender).func_110124_au()) < amount) {
            throw new InsufficientCreditException(((EntityPlayerMP)sender).func_110124_au());
        }
        GrandEconomyApi.takeFromBalance(((EntityPlayerMP)sender).func_110124_au(), amount, true);
        GrandEconomyApi.addToBalance(targetPlayer.func_110124_au(), amount, true);
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandPay.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP;
    }
}

