/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.commands;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import the_fireplace.grandeconomy.api.GrandEconomyApi;
import the_fireplace.grandeconomy.translation.TranslationUtil;

public class CommandWallet
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "wallet";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nullable ICommandSender sender) {
        return TranslationUtil.getRawTranslationString(sender, "commands.grandeconomy.wallet.usage");
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length > 1) {
            GameProfile target = server.func_152358_ax().func_152655_a(args[1]);
            if (target == null) {
                throw new PlayerNotFoundException("commands.generic.player.notFound", new Object[]{args[1]});
            }
            if ("balance".equals(args[0])) {
                sender.func_145747_a(TranslationUtil.getTranslation(sender, "commands.grandeconomy.wallet.balance", target.getName(), GrandEconomyApi.getBalance(target.getId())));
                return;
            }
            if (args.length > 2) {
                long amount = CommandWallet.func_175766_b((String)args[2]);
                if ("set".equals(args[0])) {
                    if (amount < 0L) {
                        throw new CommandException("commands.grandeconomy.wallet.negative", new Object[]{target.getName()});
                    }
                    GrandEconomyApi.setBalance(target.getId(), amount, true);
                    sender.func_145747_a(TranslationUtil.getTranslation(sender, "commands.grandeconomy.wallet.set", target.getName(), GrandEconomyApi.getBalance(target.getId())));
                    return;
                }
                if ("give".equals(args[0]) || "add".equals(args[0])) {
                    if (GrandEconomyApi.getBalance(target.getId()) + amount < 0L) {
                        throw new CommandException("commands.grandeconomy.wallet.negative", new Object[]{target.getName()});
                    }
                    GrandEconomyApi.addToBalance(target.getId(), amount, true);
                    sender.func_145747_a(TranslationUtil.getTranslation(sender, "commands.grandeconomy.wallet.given", amount, target.getName()));
                    return;
                }
                if ("take".equals(args[0])) {
                    if (GrandEconomyApi.getBalance(target.getId()) - amount < 0L) {
                        throw new CommandException("commands.grandeconomy.wallet.negative", new Object[]{target.getName()});
                    }
                    GrandEconomyApi.takeFromBalance(target.getId(), amount, true);
                    sender.func_145747_a(TranslationUtil.getTranslation(sender, "commands.grandeconomy.wallet.taken", amount, target.getName()));
                    return;
                }
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandWallet.func_71530_a((String[])args, (String[])new String[]{"give", "take", "set", "balance", "add"});
        }
        if (args.length == 2) {
            return CommandWallet.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }
}

