/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.compat.sponge;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransactionType;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;
import the_fireplace.grandeconomy.GrandEconomy;
import the_fireplace.grandeconomy.api.GrandEconomyApi;
import the_fireplace.grandeconomy.compat.sponge.ISpongeCompat;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RegisterSpongeEconomy
implements EconomyService,
ISpongeCompat {
    private TransactionType genericTransactionType = new TransactionType(){

        public String getId() {
            return "grandeconomy-generic";
        }

        public String getName() {
            return "Generic";
        }
    };
    private Currency geCurrency = new Currency(){

        public String getId() {
            return "grandeconomy-gp";
        }

        public String getName() {
            return this.getDisplayName().toPlain();
        }

        public Text getDisplayName() {
            return Text.of((String)GrandEconomyApi.getCurrencyName(1L));
        }

        public Text getPluralDisplayName() {
            return Text.of((String)GrandEconomyApi.getCurrencyName(2L));
        }

        public Text getSymbol() {
            return Text.EMPTY;
        }

        public Text format(BigDecimal amount, int numFractionDigits) {
            return Text.of((String)GrandEconomyApi.toString(amount.longValue()));
        }

        public int getDefaultFractionDigits() {
            return 0;
        }

        public boolean isDefault() {
            return true;
        }
    };
    private HashMap<UUID, UniqueAccount> accts = Maps.newHashMap();

    public Currency getDefaultCurrency() {
        return this.geCurrency;
    }

    public Set<Currency> getCurrencies() {
        return Sets.newHashSet((Object[])new Currency[]{this.geCurrency});
    }

    public boolean hasAccount(UUID uuid) {
        return GrandEconomyApi.ensureAccountExists(uuid, null);
    }

    public boolean hasAccount(String identifier) {
        try {
            return GrandEconomyApi.ensureAccountExists(UUID.fromString(identifier), null);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Optional<UniqueAccount> getOrCreateAccount(final UUID uuid) {
        if (!this.accts.containsKey(uuid)) {
            this.accts.put(uuid, new UniqueAccount(){

                public Text getDisplayName() {
                    GameProfile profile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid);
                    return Text.of((String)(profile != null ? profile.getName() : uuid.toString()));
                }

                public BigDecimal getDefaultBalance(Currency currency) {
                    return BigDecimal.valueOf(GrandEconomy.cfg.startBalance);
                }

                public boolean hasBalance(Currency currency, Set<Context> contexts) {
                    return GrandEconomyApi.getBalance(this.getUniqueId(), null) > 0L;
                }

                public BigDecimal getBalance(Currency currency, Set<Context> contexts) {
                    return BigDecimal.valueOf(GrandEconomyApi.getBalance(this.getUniqueId(), null));
                }

                public Map<Currency, BigDecimal> getBalances(Set<Context> contexts) {
                    return Maps.asMap(Collections.singleton(RegisterSpongeEconomy.this.geCurrency), x -> this.getBalance((Currency)x, contexts));
                }

                public TransactionResult setBalance(Currency currency, final BigDecimal amount, Cause cause, final Set<Context> contexts) {
                    return new TransactionResult(){

                        public Account getAccount() {
                            return (Account)RegisterSpongeEconomy.this.accts.get(this.getUniqueId());
                        }

                        public Currency getCurrency() {
                            return RegisterSpongeEconomy.this.geCurrency;
                        }

                        public BigDecimal getAmount() {
                            return amount;
                        }

                        public Set<Context> getContexts() {
                            return contexts;
                        }

                        public ResultType getResult() {
                            return GrandEconomyApi.setBalance(this.getUniqueId(), amount.longValue(), null) ? ResultType.SUCCESS : ResultType.FAILED;
                        }

                        public TransactionType getType() {
                            return RegisterSpongeEconomy.this.genericTransactionType;
                        }
                    };
                }

                public Map<Currency, TransactionResult> resetBalances(Cause cause, Set<Context> contexts) {
                    return Maps.asMap(Collections.singleton(RegisterSpongeEconomy.this.geCurrency), x -> this.resetBalance((Currency)x, cause));
                }

                public TransactionResult resetBalance(Currency currency, Cause cause, final Set<Context> contexts) {
                    GrandEconomyApi.setBalance(uuid, GrandEconomy.cfg.startBalance, null);
                    return new TransactionResult(){

                        public Account getAccount() {
                            return (Account)RegisterSpongeEconomy.this.accts.get(uuid);
                        }

                        public Currency getCurrency() {
                            return RegisterSpongeEconomy.this.geCurrency;
                        }

                        public BigDecimal getAmount() {
                            return BigDecimal.ZERO;
                        }

                        public Set<Context> getContexts() {
                            return contexts;
                        }

                        public ResultType getResult() {
                            return ResultType.SUCCESS;
                        }

                        public TransactionType getType() {
                            return RegisterSpongeEconomy.this.genericTransactionType;
                        }
                    };
                }

                public TransactionResult deposit(Currency currency, final BigDecimal amount, Cause cause, final Set<Context> contexts) {
                    return new TransactionResult(){

                        public Account getAccount() {
                            return (Account)RegisterSpongeEconomy.this.accts.get(this.getUniqueId());
                        }

                        public Currency getCurrency() {
                            return RegisterSpongeEconomy.this.geCurrency;
                        }

                        public BigDecimal getAmount() {
                            return amount;
                        }

                        public Set<Context> getContexts() {
                            return contexts;
                        }

                        public ResultType getResult() {
                            GrandEconomyApi.addToBalance(this.getUniqueId(), amount.longValue(), null);
                            return ResultType.SUCCESS;
                        }

                        public TransactionType getType() {
                            return RegisterSpongeEconomy.this.genericTransactionType;
                        }
                    };
                }

                public TransactionResult withdraw(Currency currency, final BigDecimal amount, Cause cause, final Set<Context> contexts) {
                    return new TransactionResult(){

                        public Account getAccount() {
                            return (Account)RegisterSpongeEconomy.this.accts.get(this.getUniqueId());
                        }

                        public Currency getCurrency() {
                            return RegisterSpongeEconomy.this.geCurrency;
                        }

                        public BigDecimal getAmount() {
                            return amount;
                        }

                        public Set<Context> getContexts() {
                            return contexts;
                        }

                        public ResultType getResult() {
                            return GrandEconomyApi.takeFromBalance(this.getUniqueId(), amount.longValue(), null) ? ResultType.SUCCESS : ResultType.FAILED;
                        }

                        public TransactionType getType() {
                            return RegisterSpongeEconomy.this.genericTransactionType;
                        }
                    };
                }

                public TransferResult transfer(final Account to, Currency currency, final BigDecimal amount, Cause cause, final Set<Context> contexts) {
                    return new TransferResult(){

                        public Account getAccountTo() {
                            return to;
                        }

                        public Account getAccount() {
                            return (Account)RegisterSpongeEconomy.this.accts.get(this.getUniqueId());
                        }

                        public Currency getCurrency() {
                            return RegisterSpongeEconomy.this.geCurrency;
                        }

                        public BigDecimal getAmount() {
                            return amount;
                        }

                        public Set<Context> getContexts() {
                            return contexts;
                        }

                        public ResultType getResult() {
                            boolean taken = GrandEconomyApi.takeFromBalance(this.getUniqueId(), amount.longValue(), null);
                            if (taken) {
                                GrandEconomyApi.addToBalance(UUID.fromString(to.getIdentifier()), amount.longValue(), null);
                            }
                            return taken ? ResultType.SUCCESS : ResultType.FAILED;
                        }

                        public TransactionType getType() {
                            return RegisterSpongeEconomy.this.genericTransactionType;
                        }
                    };
                }

                public String getIdentifier() {
                    return this.getUniqueId().toString();
                }

                public Set<Context> getActiveContexts() {
                    return Collections.singleton(new Context("user", "user"));
                }

                public UUID getUniqueId() {
                    return uuid;
                }
            });
        }
        return Optional.of(this.accts.get(uuid));
    }

    public Optional<Account> getOrCreateAccount(String identifier) {
        try {
            UUID uuid = UUID.fromString(identifier);
            Optional<UniqueAccount> opt = this.getOrCreateAccount(uuid);
            if (opt.isPresent()) {
                return Optional.of(opt.get());
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public void registerContextCalculator(ContextCalculator<Account> calculator) {
    }

    @Override
    public void register() {
        Sponge.getServiceManager().setProvider((Object)GrandEconomy.instance, EconomyService.class, (Object)this);
    }
}

