/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.earnings;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import the_fireplace.grandeconomy.GrandEconomy;

public final class ConversionItems {
    static ConversionItems instance = null;
    private Map<ResourceLocation, Map<Integer, Integer>> items = Maps.newHashMap();

    private static ConversionItems getInstance() {
        if (instance == null) {
            ConversionItems.load();
        }
        return instance;
    }

    public static boolean hasValue(ResourceLocation itemResource, int meta) {
        return ConversionItems.getInstance().items.containsKey(itemResource) && ConversionItems.getInstance().items.get(itemResource).containsKey(meta) && ConversionItems.getInstance().items.get(itemResource).get(meta) > 0;
    }

    public static int getValue(ResourceLocation itemResource, int meta) {
        return ConversionItems.getInstance().items.containsKey(itemResource) && ConversionItems.getInstance().items.get(itemResource).containsKey(meta) && ConversionItems.getInstance().items.get(itemResource).get(meta) > 0 ? ConversionItems.getInstance().items.get(itemResource).get(meta) : 0;
    }

    private static void load() {
        instance = new ConversionItems();
        JsonParser jsonParser = new JsonParser();
        try {
            JsonElement obj = jsonParser.parse((Reader)new FileReader(new File(GrandEconomy.configDir, "conversion_items.json")));
            if (obj instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)obj;
                JsonArray itemMap = jsonObject.get("items").getAsJsonArray();
                for (int i = 0; i < itemMap.size(); ++i) {
                    ResourceLocation res = new ResourceLocation(itemMap.get(i).getAsJsonObject().get("item").getAsString());
                    if (!ConversionItems.instance.items.containsKey(res)) {
                        ConversionItems.instance.items.put(res, Maps.newHashMap());
                    }
                    ConversionItems.instance.items.get(res).put(itemMap.get(i).getAsJsonObject().get("meta").getAsInt(), itemMap.get(i).getAsJsonObject().get("value").getAsInt());
                }
            }
        }
        catch (FileNotFoundException e) {
            ConversionItems.instance.items.put(new ResourceLocation("minecraft:bedrock"), Maps.asMap(Collections.singleton(0), x -> 30));
            ConversionItems.instance.items.put(new ResourceLocation("minecraft:command_block"), Maps.asMap(Collections.singleton(0), x -> 50));
            ConversionItems.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void save() {
        JsonObject obj = new JsonObject();
        JsonArray itemMap = new JsonArray();
        for (Map.Entry<ResourceLocation, Map<Integer, Integer>> entry : ConversionItems.instance.items.entrySet()) {
            JsonObject outputEntry = new JsonObject();
            for (Map.Entry<Integer, Integer> entry1 : entry.getValue().entrySet()) {
                outputEntry.add("item", (JsonElement)new JsonPrimitive(entry.getKey().toString()));
                outputEntry.add("meta", (JsonElement)new JsonPrimitive((Number)entry1.getKey()));
                outputEntry.add("value", (JsonElement)new JsonPrimitive((Number)entry1.getValue()));
            }
            itemMap.add((JsonElement)outputEntry);
        }
        obj.add("items", (JsonElement)itemMap);
        try {
            FileWriter file = new FileWriter(new File(GrandEconomy.configDir, "conversion_items.json"));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)obj);
            file.write(json);
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

