/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.econhandlers.ep;

import com.kamildanak.minecraft.enderpay.api.EnderPayApi;
import com.kamildanak.minecraft.enderpay.api.InsufficientCreditException;
import com.kamildanak.minecraft.enderpay.api.NoSuchAccountException;
import com.kamildanak.minecraft.enderpay.economy.Account;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import the_fireplace.grandeconomy.econhandlers.IEconHandler;

public class EnderPayEconHandler
implements IEconHandler {
    @Override
    public long getBalance(UUID uuid, Boolean isPlayer) {
        try {
            return EnderPayApi.getBalance((UUID)uuid);
        }
        catch (NoSuchAccountException e) {
            return 0L;
        }
    }

    @Override
    public boolean addToBalance(UUID uuid, long amount, Boolean isPlayer) {
        try {
            EnderPayApi.addToBalance((UUID)uuid, (long)amount);
            return true;
        }
        catch (NoSuchAccountException ignored) {
            return false;
        }
    }

    @Override
    public boolean takeFromBalance(UUID uuid, long amount, Boolean isPlayer) {
        try {
            EnderPayApi.takeFromBalance((UUID)uuid, (long)amount);
            return true;
        }
        catch (InsufficientCreditException | NoSuchAccountException e) {
            return false;
        }
    }

    @Override
    public boolean setBalance(UUID uuid, long amount, Boolean isPlayer) {
        try {
            EnderPayApi.takeFromBalance((UUID)uuid, (long)EnderPayApi.getBalance((UUID)uuid));
            EnderPayApi.addToBalance((UUID)uuid, (long)amount);
            return true;
        }
        catch (InsufficientCreditException | NoSuchAccountException e) {
            return false;
        }
    }

    @Override
    public String getCurrencyName(long amount) {
        return EnderPayApi.getCurrencyName((long)amount);
    }

    @Override
    public String toString(long amount) {
        return amount + 32L + this.getCurrencyName(amount);
    }

    @Override
    public boolean ensureAccountExists(UUID uuid, Boolean isPlayer) {
        return Account.get((UUID)uuid) != null;
    }

    @Override
    public Boolean forceSave(UUID uuid, Boolean isPlayer) {
        try {
            Objects.requireNonNull(Account.get((UUID)uuid)).writeIfChanged();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getId() {
        return "enderpay";
    }

    @Override
    public void init() {
    }
}

