/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.econhandlers.ge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import the_fireplace.grandeconomy.GrandEconomy;
import the_fireplace.grandeconomy.TimeUtils;

public class Account {
    private static HashMap<String, Account> objects = new HashMap();
    private static File location;
    private boolean changed;
    private UUID uuid;
    private long balance;
    private long lastLogin;
    private long lastCountActivity;
    private boolean isPlayer = false;

    private Account(UUID uuid) {
        long now;
        this.uuid = uuid;
        this.balance = GrandEconomy.cfg.startBalance;
        this.lastLogin = now = TimeUtils.getCurrentDay();
        this.lastCountActivity = now;
        this.changed = true;
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid) != null) {
            this.isPlayer = true;
        }
    }

    public static Account get(EntityPlayer player) {
        return Account.get(player.func_110124_au());
    }

    @Nullable
    public static Account get(UUID uuid) {
        Account account = objects.get(uuid.toString());
        if (account != null) {
            return account;
        }
        if (location == null) {
            return null;
        }
        location.mkdirs();
        account = new Account(uuid);
        objects.put(uuid.toString(), account);
        File file = account.getFile();
        if (!file.exists()) {
            return account;
        }
        account.read();
        return account;
    }

    public static void clear() {
        location = null;
        objects.clear();
    }

    public static void setLocation(File location) {
        Account.location = location;
    }

    boolean update() {
        long now = TimeUtils.getCurrentDay();
        long activityDeltaDays = now - this.lastCountActivity;
        this.lastCountActivity = now;
        if (!this.isPlayer || activityDeltaDays == 0L) {
            return false;
        }
        if (GrandEconomy.cfg.basicIncome && this.getPlayerMP() != null) {
            long loginDeltaDays = now - this.lastLogin;
            if (loginDeltaDays > (long)GrandEconomy.cfg.maxBasicIncomeDays) {
                loginDeltaDays = GrandEconomy.cfg.maxBasicIncomeDays;
            }
            this.lastLogin = now;
            this.balance += loginDeltaDays * (long)GrandEconomy.cfg.basicIncomeAmount;
        }
        return activityDeltaDays > 0L;
    }

    void writeIfChanged() throws IOException {
        if (this.changed) {
            this.write();
        }
    }

    private File getFile() {
        return new File(location, this.uuid + ".json");
    }

    private void read() {
        this.read(this.getFile());
    }

    private void read(File file) {
        this.changed = false;
        JsonParser jsonParser = new JsonParser();
        try {
            JsonElement obj = jsonParser.parse((Reader)new FileReader(file));
            JsonObject jsonObject = (JsonObject)obj;
            this.balance = jsonObject.get("balance").getAsLong();
            this.lastLogin = jsonObject.get("lastLogin").getAsLong();
            this.lastCountActivity = jsonObject.get("lastCountActivity").getAsLong();
            if (jsonObject.has("isPlayer")) {
                this.isPlayer = jsonObject.get("isPlayer").getAsBoolean();
            } else if (FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(this.uuid) != null) {
                this.isPlayer = true;
                this.changed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void write() throws IOException {
        this.write(this.getFile());
    }

    private void write(File location) throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("balance", (Number)this.balance);
        obj.addProperty("lastLogin", (Number)this.lastLogin);
        obj.addProperty("lastCountActivity", (Number)this.lastCountActivity);
        obj.addProperty("isPlayer", Boolean.valueOf(this.isPlayer));
        try (FileWriter file = new FileWriter(location);){
            String str = obj.toString();
            file.write(str);
        }
        this.changed = false;
    }

    public long getBalance() {
        return this.balance;
    }

    void setBalance(long v, boolean showMsg) {
        if (this.balance != v) {
            this.balance = v;
            this.changed = true;
        }
        if (showMsg) {
            Objects.requireNonNull(this.getPlayerMP()).func_145747_a((ITextComponent)new TextComponentTranslation("Your balance is now: %s", new Object[]{this.balance}));
        }
    }

    void addBalance(long v, boolean showMsg) {
        this.setBalance(this.balance + v, showMsg);
    }

    @Nullable
    private EntityPlayerMP getPlayerMP() {
        return GrandEconomy.minecraftServer.func_184103_al().func_177451_a(this.uuid);
    }
}

