/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.econhandlers.ge;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import the_fireplace.grandeconomy.GrandEconomy;
import the_fireplace.grandeconomy.compat.sponge.RegisterSpongeEconomy;
import the_fireplace.grandeconomy.econhandlers.IEconHandler;
import the_fireplace.grandeconomy.econhandlers.ge.Account;
import the_fireplace.grandeconomy.econhandlers.ge.EventHandler;

public class GrandEconomyEconHandler
implements IEconHandler {
    @Override
    public long getBalance(UUID uuid, Boolean isPlayer) {
        Account account = Account.get(uuid);
        if (account == null) {
            GrandEconomy.LOGGER.warn("Account for %s was null", (Object)uuid.toString());
            return 0L;
        }
        account.update();
        return account.getBalance();
    }

    @Override
    public boolean addToBalance(UUID uuid, long amount, Boolean isPlayer) {
        Account account = Account.get(uuid);
        if (account == null) {
            GrandEconomy.LOGGER.warn("Account for %s was null", (Object)uuid.toString());
            return false;
        }
        if (account.getBalance() + amount < 0L) {
            return false;
        }
        account.addBalance(amount, false);
        return true;
    }

    @Override
    public boolean takeFromBalance(UUID uuid, long amount, Boolean isPlayer) {
        Account account = Account.get(uuid);
        if (account == null) {
            GrandEconomy.LOGGER.warn("Account for %s was null", (Object)uuid.toString());
            return false;
        }
        if (account.getBalance() < amount) {
            return false;
        }
        account.addBalance(-amount, false);
        return true;
    }

    @Override
    public boolean setBalance(UUID uuid, long amount, Boolean isPlayer) {
        Account account = Account.get(uuid);
        if (account == null) {
            GrandEconomy.LOGGER.warn("Account for %s was null", (Object)uuid.toString());
            return false;
        }
        if (amount < 0L) {
            return false;
        }
        account.setBalance(amount, false);
        return true;
    }

    @Override
    public String getCurrencyName(long amount) {
        if (amount == 1L) {
            return GrandEconomy.cfg.currencyNameSingular;
        }
        return GrandEconomy.cfg.currencyNameMultiple;
    }

    @Override
    public String toString(long amount) {
        return amount + 32L + this.getCurrencyName(amount);
    }

    @Override
    public boolean ensureAccountExists(UUID uuid, Boolean isPlayer) {
        return Account.get(uuid) != null;
    }

    @Override
    public Boolean forceSave(UUID uuid, Boolean isPlayer) {
        try {
            Objects.requireNonNull(Account.get(uuid)).writeIfChanged();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getId() {
        return "grandeconomy";
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        if (Loader.isModLoaded((String)"spongeapi")) {
            RegisterSpongeEconomy compat = new RegisterSpongeEconomy();
            compat.register();
        }
    }
}

