/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.econhandlers.sponge;

import java.math.BigDecimal;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import the_fireplace.grandeconomy.GrandEconomy;
import the_fireplace.grandeconomy.econhandlers.IEconHandler;

public class SpongeEconHandler
implements IEconHandler {
    private EconomyService spongeEcon;

    private EconomyService getEcon() {
        if (this.spongeEcon == null) {
            this.spongeEcon = Sponge.getServiceManager().provide(EconomyService.class).isPresent() ? (EconomyService)Sponge.getServiceManager().provide(EconomyService.class).get() : null;
        }
        return this.spongeEcon;
    }

    @Override
    public long getBalance(UUID uuid, Boolean isPlayer) {
        if (this.getEcon() != null && this.getEcon().getOrCreateAccount(uuid).isPresent()) {
            return ((UniqueAccount)this.getEcon().getOrCreateAccount(uuid).get()).getBalance(this.getEcon().getDefaultCurrency()).longValue();
        }
        return 0L;
    }

    @Override
    public boolean addToBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.getEcon() != null && this.getEcon().getOrCreateAccount(uuid).isPresent()) {
            return ((UniqueAccount)this.getEcon().getOrCreateAccount(uuid).get()).deposit(this.getEcon().getDefaultCurrency(), BigDecimal.valueOf(amount), Cause.of((EventContext)EventContext.empty(), (Object)GrandEconomy.getEconomy())).getResult().equals((Object)ResultType.SUCCESS);
        }
        return false;
    }

    @Override
    public boolean takeFromBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.getEcon() != null && this.getEcon().getOrCreateAccount(uuid).isPresent()) {
            return ((UniqueAccount)this.getEcon().getOrCreateAccount(uuid).get()).withdraw(this.getEcon().getDefaultCurrency(), BigDecimal.valueOf(amount), Cause.of((EventContext)EventContext.empty(), (Object)GrandEconomy.getEconomy())).getResult().equals((Object)ResultType.SUCCESS);
        }
        return false;
    }

    @Override
    public boolean setBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.getEcon() != null && this.getEcon().getOrCreateAccount(uuid).isPresent()) {
            return ((UniqueAccount)this.getEcon().getOrCreateAccount(uuid).get()).setBalance(this.getEcon().getDefaultCurrency(), BigDecimal.valueOf(amount), Cause.of((EventContext)EventContext.empty(), (Object)GrandEconomy.getEconomy())).getResult().equals((Object)ResultType.SUCCESS);
        }
        return false;
    }

    @Override
    public String getCurrencyName(long amount) {
        return amount == 1L ? this.getEcon().getDefaultCurrency().getDisplayName().toPlain() : this.getEcon().getDefaultCurrency().getPluralDisplayName().toPlain();
    }

    @Override
    public String toString(long amount) {
        return this.getEcon().getDefaultCurrency().format(BigDecimal.valueOf(amount)).toPlain();
    }

    @Override
    public boolean ensureAccountExists(UUID uuid, Boolean isPlayer) {
        return this.getEcon() != null && this.getEcon().getOrCreateAccount(uuid).isPresent();
    }

    @Override
    public Boolean forceSave(UUID uuid, Boolean isPlayer) {
        return null;
    }

    @Override
    public String getId() {
        return Sponge.getServiceManager().getRegistration(EconomyService.class).isPresent() ? ((ProviderRegistration)Sponge.getServiceManager().getRegistration(EconomyService.class).get()).getPlugin().getId() : "spongeapi";
    }

    @Override
    public void init() {
    }
}

