/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.econhandlers.vault;

import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import the_fireplace.grandeconomy.econhandlers.IEconHandler;

public class VaultEconHandler
implements IEconHandler {
    private Economy econ;

    private boolean shouldUsePlayerAccount(UUID uuid, Boolean isPlayer) {
        return isPlayer == null && Bukkit.getOfflinePlayer((UUID)uuid).hasPlayedBefore() || isPlayer == Boolean.TRUE || !this.econ.hasBankSupport();
    }

    @Override
    public long getBalance(UUID uuid, Boolean isPlayer) {
        if (this.shouldUsePlayerAccount(uuid, isPlayer)) {
            return (long)this.econ.getBalance(Bukkit.getOfflinePlayer((UUID)uuid));
        }
        return (long)this.econ.bankBalance((String)uuid.toString()).balance;
    }

    @Override
    public boolean addToBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.shouldUsePlayerAccount(uuid, isPlayer)) {
            return this.econ.depositPlayer(Bukkit.getOfflinePlayer((UUID)uuid), (double)amount).transactionSuccess();
        }
        return this.econ.bankDeposit(uuid.toString(), (double)amount).transactionSuccess();
    }

    @Override
    public boolean takeFromBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.shouldUsePlayerAccount(uuid, isPlayer)) {
            return this.econ.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)uuid), (double)amount).transactionSuccess();
        }
        return this.econ.bankWithdraw(uuid.toString(), (double)amount).transactionSuccess();
    }

    @Override
    public boolean setBalance(UUID uuid, long amount, Boolean isPlayer) {
        if (this.shouldUsePlayerAccount(uuid, isPlayer)) {
            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
            if (this.econ.getBalance(p) > (double)amount) {
                return this.econ.withdrawPlayer(p, (double)amount - this.econ.getBalance(p)).transactionSuccess();
            }
            return this.econ.depositPlayer(p, this.econ.getBalance(p) - (double)amount).transactionSuccess();
        }
        if (this.econ.bankBalance((String)uuid.toString()).balance > (double)amount) {
            return this.econ.bankWithdraw(uuid.toString(), (double)amount - this.econ.bankBalance((String)uuid.toString()).balance).transactionSuccess();
        }
        return this.econ.bankDeposit(uuid.toString(), this.econ.bankBalance((String)uuid.toString()).balance - (double)amount).transactionSuccess();
    }

    @Override
    public String getCurrencyName(long amount) {
        return amount == 1L ? this.econ.currencyNameSingular() : this.econ.currencyNamePlural();
    }

    @Override
    public String toString(long amount) {
        return this.econ.format((double)amount);
    }

    @Override
    public boolean ensureAccountExists(UUID uuid, Boolean isPlayer) {
        if (this.shouldUsePlayerAccount(uuid, isPlayer)) {
            return this.econ.hasAccount(Bukkit.getOfflinePlayer((UUID)uuid)) || this.econ.createPlayerAccount(Bukkit.getOfflinePlayer((UUID)uuid));
        }
        return this.econ.getBanks().contains(uuid.toString()) || this.econ.createBank(uuid.toString(), Bukkit.getOfflinePlayer((UUID)uuid)).transactionSuccess();
    }

    @Override
    public Boolean forceSave(UUID uuid, Boolean isPlayer) {
        return null;
    }

    @Override
    public String getId() {
        return "vault";
    }

    @Override
    public void init() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        this.econ = (Economy)economyProvider.getProvider();
    }
}

