/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.grandeconomy.translation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import the_fireplace.grandeconomy.GrandEconomy;

public class GrandEconomyLanguageMap {
    private static final Pattern NUMERIC_VARIABLE_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final Splitter EQUAL_SIGN_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final GrandEconomyLanguageMap instance = new GrandEconomyLanguageMap(GrandEconomy.cfg.locale);
    private final Map<String, String> languageList = Maps.newHashMap();

    GrandEconomyLanguageMap(String locale) {
        InputStream inputstream = GrandEconomyLanguageMap.class.getResourceAsStream("/assets/grandeconomy/lang/" + locale + ".lang");
        GrandEconomyLanguageMap.inject(this, inputstream);
    }

    public static void inject(InputStream inputstream) {
        GrandEconomyLanguageMap.inject(instance, inputstream);
    }

    private static void inject(GrandEconomyLanguageMap inst, InputStream inputstream) {
        Map<String, String> map = GrandEconomyLanguageMap.parseLangFile(inputstream);
        inst.languageList.putAll(map);
    }

    private static Map<String, String> parseLangFile(InputStream inputstream) {
        HashMap table = Maps.newHashMap();
        try {
            inputstream = FMLCommonHandler.instance().loadLanguage((Map)table, inputstream);
            if (inputstream == null) {
                return table;
            }
            for (String s : IOUtils.readLines((InputStream)inputstream, (Charset)StandardCharsets.UTF_8)) {
                String[] astring;
                if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)EQUAL_SIGN_SPLITTER.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
                String s1 = astring[0];
                String s2 = NUMERIC_VARIABLE_PATTERN.matcher(astring[1]).replaceAll("%$1s");
                table.put(s1, s2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table;
    }

    static GrandEconomyLanguageMap getInstance() {
        return instance;
    }

    synchronized String translateKeyFormat(String key, Object ... format) {
        String s = this.tryTranslateKey(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            return "Format error: " + s;
        }
    }

    private String tryTranslateKey(String key) {
        String s = this.languageList.get(key);
        return s == null ? key : s;
    }

    synchronized boolean isKeyTranslated(String key) {
        return this.languageList.containsKey(key);
    }
}

