/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.infinity;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.infinity.ItemBlockInfinity;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.ClientUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInfinity
extends BlockFalling
implements IResourceTooltipProvider,
IHaveRenderers,
IModObject.WithBlockItem {
    @Nonnull
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)2);
    private static final int[] COLS = new int[]{65793, 0x111111, 0x222222, 0x333333, 0xFFFFFF};

    public static BlockInfinity create(@Nonnull IModObject modObject) {
        BlockInfinity result = new BlockInfinity(modObject);
        return result;
    }

    protected BlockInfinity(@Nonnull IModObject modObject) {
        super((Material)new NotRock(MapColor.field_151654_J));
        modObject.apply(this);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.initDefaultState();
        for (int i = 0; i <= 2; ++i) {
            this.setHarvestLevel("shovel", i + 1, this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(i)));
        }
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new ItemBlockInfinity((Block)this){

            @Nonnull
            public String func_77667_c(@Nonnull ItemStack stack) {
                return super.func_77667_c(stack) + "_" + stack.func_77960_j();
            }
        });
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)2)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (rand.nextFloat() < (float)((Integer)state.func_177229_b((IProperty)LEVEL) + 1) * 0.25f) {
            double yd;
            double xd;
            EnumFacing face = EnumFacing.values()[rand.nextInt(EnumFacing.values().length)];
            double d = face.func_82601_c() == 0 ? rand.nextDouble() : (xd = face.func_82601_c() < 0 ? -0.05 : 1.05);
            double d2 = face.func_96559_d() == 0 ? rand.nextDouble() : (yd = face.func_96559_d() < 0 ? -0.05 : 1.05);
            double zd = face.func_82599_e() == 0 ? rand.nextDouble() : (face.func_82599_e() < 0 ? -0.05 : 1.05);
            double x = (double)pos.func_177958_n() + xd;
            double y = (double)pos.func_177956_o() + yd;
            double z = (double)pos.func_177952_p() + zd;
            int col = COLS[rand.nextInt(COLS.length)];
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)(col >> 16 & 0xFF) / 255.0, (double)(col >> 8 & 0xFF) / 255.0, (double)(col & 0xFF) / 255.0, new int[0]);
        }
        if (rand.nextInt(16) == 0) {
            for (int i = 0; i <= 1; ++i) {
                BlockPos blockpos = pos.func_177979_c(i);
                if (!BlockInfinity.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) continue;
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (double)pos.func_177956_o() - 0.05;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(@Nonnull IBlockState state) {
        return -COLS[RANDOM.nextInt(COLS.length)];
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b().func_77667_c(itemStack);
    }

    private boolean breakup(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, float baseChance) {
        if (!worldIn.field_72995_K && RANDOM.nextFloat() < (float)((Integer)state.func_177229_b((IProperty)LEVEL) + 1) * baseChance) {
            CapturedMob capturedMob;
            int count;
            switch ((Integer)state.func_177229_b((IProperty)LEVEL)) {
                case 2: {
                    count = 729;
                    break;
                }
                case 1: {
                    count = 81;
                    break;
                }
                default: {
                    count = 9;
                }
            }
            worldIn.func_175698_g(pos);
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            while (count > 0) {
                int num = MathHelper.func_76125_a((int)RANDOM.nextInt(Math.max(count / 5, 1)), (int)1, (int)Math.min(count, 64));
                count -= num;
                BlockInfinity.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)crazypants.enderio.base.material.material.Material.POWDER_INFINITY.getStack(num));
            }
            if (RANDOM.nextFloat() < (float)((Integer)state.func_177229_b((IProperty)LEVEL) + 1) * 0.3f && (capturedMob = CapturedMob.create(new ResourceLocation("minecraft", "endermite"))) != null) {
                capturedMob.doSpawn(worldIn, pos, EnumFacing.DOWN, false);
            }
            return true;
        }
        return false;
    }

    public void func_176224_k(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        this.breakup(worldIn.func_180495_p(pos), worldIn, pos, 0.025f);
    }

    public void func_180658_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn, float fallDistance) {
        if (this.breakup(worldIn.func_180495_p(pos), worldIn, pos, fallDistance / 10.0f)) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance - 3.0f);
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!this.tryTouchWater(worldIn, pos, state)) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }
    }

    private boolean tryTouchWater(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing == EnumFacing.DOWN || enumfacing == null || !worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_185904_a().func_76224_d()) continue;
            this.breakup(state, worldIn, pos, 1.0f);
            return true;
        }
        return false;
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!this.tryTouchWater(worldIn, pos, state)) {
            super.func_176213_c(worldIn, pos, state);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        for (int i = 0; i <= 2; ++i) {
            ClientUtil.regRenderer((Block)this, i, LEVEL.func_177701_a() + "=" + LEVEL.func_177702_a(Integer.valueOf(i)));
        }
    }

    public void func_149666_a(@Nonnull CreativeTabs itemIn, @Nonnull NonNullList<ItemStack> items) {
        for (int i = 0; i <= 2; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    private static class NotRock
    extends Material {
        public NotRock(@Nonnull MapColor color) {
            super(color);
            this.func_76221_f();
        }
    }
}

