/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.explosive;

import com.enderio.core.common.util.NNList;
import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.PlayerAOEAttributeHandler;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveCarpetUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveDepthUpgrade;
import crazypants.enderio.base.lang.Lang;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class ExplosiveUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "tnt";
    @Nonnull
    private static final UUID UPGRADE_UUID = UUID.nameUUIDFromBytes("tnt".getBytes(Charsets.UTF_8));
    @Nonnull
    public static final ExplosiveUpgrade INSTANCE = new ExplosiveUpgrade(0);
    @Nonnull
    public static final ExplosiveUpgrade INSTANCE2 = new ExplosiveUpgrade(1);
    @Nonnull
    public static final ExplosiveUpgrade INSTANCE3 = new ExplosiveUpgrade(2);
    @Nonnull
    public static final ExplosiveUpgrade INSTANCE4 = new ExplosiveUpgrade(3);
    @Nonnull
    public static final ExplosiveUpgrade INSTANCE5 = new ExplosiveUpgrade(4);
    @Nonnull
    public static final IRule.Prerequisite HAS_ANY = new IRule.Prerequisite(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            for (ExplosiveUpgrade upgrade : new ExplosiveUpgrade[]{INSTANCE, INSTANCE2, INSTANCE3, INSTANCE4, INSTANCE5}) {
                if (!upgrade.hasUpgrade(stack, item)) continue;
                return IRule.CheckResult.PASS;
            }
            return new IRule.CheckResult((ITextComponent)Lang.DSU_CHECK_PREREQ_MISSING.toChatServer(new TextComponentTranslation(INSTANCE.getUnlocalizedName() + ".name", new Object[0])));
        }

        @Override
        @Nonnull
        public IDarkSteelUpgrade getPrerequisite() {
            return INSTANCE;
        }
    };
    @Nonnull
    static final NNList<AttributeModifier> SIZE = new NNList((Object[])new AttributeModifier[]{new AttributeModifier(UPGRADE_UUID, "tnt", 0.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 1.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 2.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 3.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 4.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 5.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 6.0, 0), new AttributeModifier(UPGRADE_UUID, "tnt", 7.0, 0)});

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE2);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE3);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE4);
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE5);
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return INSTANCE.hasAnyUpgradeVariant(player.func_184614_ca());
    }

    public ExplosiveUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.tnt." + level, (IValue<Integer>)((IValue)DarkSteelConfig.explosiveUpgradeCost.get(level)));
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.callbacksFor(INSTANCE), Rules.staticCheck(item -> item.isPickaxe()), EnergyUpgrade.HAS_ANY, Rules.withLevels(this.variant, INSTANCE, INSTANCE2, INSTANCE3, INSTANCE4), Rules.itemTypeTooltip(Lang.DSU_CLASS_TOOLS_PICKAXE)});
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    @Override
    public void addAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack, @Nonnull Multimap<String, AttributeModifier> map) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            int xyz;
            int y;
            int xz;
            boolean depth = ExplosiveDepthUpgrade.INSTANCE.hasUpgrade(stack);
            boolean carpet = ExplosiveCarpetUpgrade.INSTANCE.hasUpgrade(stack);
            if (carpet && depth) {
                xz = this.variant;
                y = this.variant + 2;
                xyz = 0;
            } else if (carpet) {
                xz = this.variant + 2;
                y = 0;
                xyz = 0;
            } else if (depth) {
                xz = 1;
                y = this.variant + 3;
                xyz = 0;
            } else {
                y = 0;
                xz = 0;
                xyz = this.variant + 1;
            }
            map.put((Object)PlayerAOEAttributeHandler.AOE_XZ.func_111108_a(), SIZE.get(xz));
            map.put((Object)PlayerAOEAttributeHandler.AOE_Y.func_111108_a(), SIZE.get(y));
            map.put((Object)PlayerAOEAttributeHandler.AOE_XYZ.func_111108_a(), SIZE.get(xyz));
        }
    }
}

