/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.yetawrench;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.handlers.ClientHandler;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class YetaWrenchOverlayRenderer {
    @Nonnull
    private static ConduitDisplayMode cachedMode = ConduitDisplayMode.ALL;
    private static int displayTickCount;
    private static long lastTick;

    @SubscribeEvent
    public static void renderOverlay(@Nonnull RenderGameOverlayEvent.Post event) {
        ItemStack equippedWrench;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && Prep.isValid(equippedWrench = YetaWrenchOverlayRenderer.getEquippedWrench())) {
            YetaWrenchOverlayRenderer.doRenderOverlay((RenderGameOverlayEvent)event, equippedWrench);
        }
    }

    @Nonnull
    private static ItemStack getEquippedWrench() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack equipped = player.func_184614_ca();
        if (equipped.func_77973_b() instanceof IConduitControl && ((IConduitControl)equipped.func_77973_b()).showOverlay(equipped, (EntityPlayer)player)) {
            return equipped;
        }
        return Prep.getEmpty();
    }

    private static void doRenderOverlay(@Nonnull RenderGameOverlayEvent event, @Nonnull ItemStack equippedWrench) {
        ConduitDisplayMode mode = ConduitDisplayMode.getDisplayMode(equippedWrench);
        if (mode != cachedMode) {
            cachedMode = mode;
            displayTickCount = 20;
            lastTick = ClientHandler.getTicksElapsed();
        }
        ScaledResolution res = event.getResolution();
        int modeCount = ConduitDisplayMode.registrySize();
        Iterable<ConduitDisplayMode> renderable = ConduitDisplayMode.getRenderableModes();
        switch ((Integer)PersonalConfig.yetaOverlayMode.get()) {
            case 0: {
                if (displayTickCount > 0) {
                    if (lastTick < (long)ClientHandler.getTicksElapsed()) {
                        ++lastTick;
                        --displayTickCount;
                    }
                    int x = res.func_78326_a() / 2 - 8;
                    int y = res.func_78328_b() / 2 - 24;
                    IWidgetIcon widget = mode.getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)x, (double)y, true);
                    int size = 12;
                    widget = mode.previous().getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)(x - 18 + (16 - size)), (double)(y + (16 - size)), (double)size, (double)size, 0.0, true);
                    widget = mode.next().getWidgetSelected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)(x + 18), (double)(y + (16 - size)), (double)size, (double)size, 0.0, true);
                    break;
                }
                int x = res.func_78326_a() - 20;
                int y = res.func_78328_b() - 20;
                IWidgetIcon widget = mode.getWidgetSelected();
                RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                widget.getMap().render(widget, (double)x, (double)y, true);
                break;
            }
            case 1: {
                int size = 16;
                int padding = 2;
                int inset = (int)((double)size / 1.5);
                int offsetX = res.func_78326_a() - inset - 1;
                int offsetY = res.func_78328_b() - modeCount * (size + padding) - padding;
                inset = size - inset;
                int x = offsetX + 2;
                int y = offsetY - padding * 2;
                int height = modeCount * (size + padding) + padding * 3;
                GL11.glDisable((int)3553);
                GL11.glShadeModel((int)7425);
                VertexFormat vf = DefaultVertexFormats.field_181706_f;
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder wr = tess.func_178180_c();
                wr.func_181668_a(7, vf);
                wr.func_181662_b((double)x, (double)y, -5.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.2f).func_181675_d();
                wr.func_181662_b((double)x, (double)(y + height), -5.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.2f).func_181675_d();
                Vector4f color = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                wr.func_181662_b((double)(x + size), (double)(y + height), -5.0).func_181666_a(color.x, color.y, color.z, color.w).func_181675_d();
                wr.func_181662_b((double)(x + size), (double)y, -5.0).func_181666_a(color.x, color.y, color.z, color.w).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glShadeModel((int)7424);
                y += padding * 2;
                x -= 2;
                if (mode == ConduitDisplayMode.ALL) {
                    x -= inset;
                }
                GL11.glEnable((int)3553);
                for (ConduitDisplayMode toRender : renderable) {
                    IWidgetIcon widget = mode == ConduitDisplayMode.ALL ? toRender.getWidgetSelected() : toRender.getWidgetUnselected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    if (toRender == mode) {
                        widget = toRender.getWidgetSelected();
                        widget.getMap().render(widget, (double)(x - inset), (double)y, true);
                    } else {
                        widget.getMap().render(widget, (double)x, (double)y, true);
                    }
                    y += size + padding;
                }
                break;
            }
            case 2: {
                int offsetX = res.func_78326_a() - modeCount * 8 - 16;
                int y = res.func_78328_b() - 40;
                int x = offsetX;
                if (modeCount % 2 == 1) {
                    x += 8;
                }
                int count = 0;
                for (ConduitDisplayMode toRender : renderable) {
                    IWidgetIcon widget = mode == ConduitDisplayMode.ALL || toRender == mode ? toRender.getWidgetSelected() : toRender.getWidgetUnselected();
                    RenderUtil.bindTexture((ResourceLocation)widget.getMap().getTexture());
                    widget.getMap().render(widget, (double)x, (double)y, true);
                    x += 16;
                    if (count == modeCount / 2 - 1) {
                        x = offsetX;
                        y += 16;
                    }
                    ++count;
                }
                break;
            }
        }
    }
}

