/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.gui.IoConfigRenderer;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class GuiOverlayIoConfig<E extends TileEntity>
implements IGuiOverlay {
    private boolean visible = false;
    private ToggleButton configB;
    private IGuiScreen screen;
    @Nonnull
    private Rectangle bounds = new Rectangle();
    int height = 80;
    private IoConfigRenderer<E> renderer;
    @Nonnull
    private NNList<BlockPos> coords = new NNList();

    public GuiOverlayIoConfig(IIoConfigurable ioConf) {
        this.coords.add((Object)ioConf.getLocation());
    }

    public GuiOverlayIoConfig(Collection<BlockPos> bc) {
        this.coords.addAll(bc);
    }

    public void setConfigB(ToggleButton configB) {
        this.configB = configB;
    }

    public void init(@Nonnull IGuiScreen screenIn) {
        this.screen = screenIn;
        this.renderer = new IoConfigRenderer<E>(this.coords){

            @Override
            @Nonnull
            protected String getLabelForMode(@Nonnull IoMode mode) {
                return GuiOverlayIoConfig.this.getLabelForMode(mode);
            }
        };
        this.renderer.init();
        this.bounds = new Rectangle(screenIn.getOverlayOffsetXLeft() + 5, screenIn.getGuiYSize() - this.height - 5, screenIn.getGuiXSize() - screenIn.getOverlayOffsetXRight() - 10, this.height);
    }

    @Nonnull
    protected String getLabelForMode(IoMode mode) {
        return mode.getLocalisedName();
    }

    public void draw(int mouseX, int mouseY, float partialTick) {
        RenderUtil.renderQuad2D((double)this.bounds.x, (double)this.bounds.y, (double)0.0, (double)this.bounds.width, (double)this.bounds.height, (int)ColorUtil.getRGB((Color)Color.black));
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int vpx = (this.screen.getGuiRootLeft() + this.screen.getOverlayOffsetXLeft() + 5) * scaledresolution.func_78325_e();
        int vpy = (this.screen.getGuiRootTop() + 4) * scaledresolution.func_78325_e();
        int w = this.bounds.width * scaledresolution.func_78325_e();
        int h = this.bounds.height * scaledresolution.func_78325_e();
        this.renderer.drawScreen(mouseX, mouseY, partialTick, new Rectangle(vpx, vpy, w, h), this.bounds);
    }

    public boolean handleMouseInput(int x, int y, int b) {
        if (!this.isMouseInBounds(x, y)) {
            this.renderer.handleMouseInput();
            return false;
        }
        this.renderer.handleMouseInput();
        return true;
    }

    public boolean isMouseInBounds(int mouseX, int mouseY) {
        int y;
        int x = mouseX - this.screen.getGuiRootLeft();
        return this.bounds.contains(x, y = mouseY - this.screen.getGuiRootTop());
    }

    public void setIsVisible(boolean visible) {
        this.visible = visible;
        if (this.configB != null) {
            this.configB.setSelected(visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Nonnull
    public Rectangle getBounds() {
        return this.bounds;
    }

    public IoConfigRenderer.SelectedFace<E> getSelection() {
        return this.visible ? this.renderer.getSelection() : null;
    }

    public void guiClosed() {
    }
}

