/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint;

import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintSourceValidator;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPiston;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.Strings;

public class PaintUtil {
    private static Things paintables = new Things();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(@Nonnull ItemStack paintSource, Block target) {
        boolean solidPaint = false;
        boolean textureOnly = false;
        if (Prep.isValid(paintSource)) {
            if (!PaintSourceValidator.instance.isValidSourceDefault(paintSource)) {
                return false;
            }
            Block block = PaintUtil.getBlockFromItem(paintSource);
            if (block == null) return false;
            if (block == Blocks.field_150350_a) {
                return false;
            }
            IBlockState bs = PaintUtil.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, block);
            solidPaint = bs.func_185914_p();
            if (!PaintUtil.shouldHaveModel(block)) {
                if (!PaintUtil.shouldHaveTexture(block)) return false;
                textureOnly = true;
            } else if (block instanceof IPaintable && (bs = ((IPaintable)block).getPaintSource(block, paintSource)) != null) {
                return false;
            }
        }
        if (target == null) {
            return Prep.isValid(paintSource);
        }
        if (Prep.isInvalid(paintSource)) {
            return target instanceof IPaintable;
        }
        if (target instanceof IPaintable.ITexturePaintableBlock) {
            return true;
        }
        if (target instanceof IPaintable.ISolidBlockPaintableBlock) {
            if (!solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (target instanceof IPaintable.INonSolidBlockPaintableBlock) {
            if (solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (!(target instanceof IPaintable.IBlockPaintableBlock)) return false;
        if (textureOnly) return false;
        return true;
    }

    public static IBlockState rotate(@Nonnull IBlockState paintSource) {
        for (IProperty prop : paintSource.func_177227_a()) {
            if (prop instanceof PropertyDirection) {
                return paintSource.func_177231_a(prop);
            }
            if (prop != BlockSlab.field_176554_a) continue;
            return paintSource.func_177231_a(prop);
        }
        if (paintSource.func_177230_c() instanceof BlockLog) {
            return paintSource.func_177231_a((IProperty)BlockLog.field_176299_a);
        }
        return paintSource;
    }

    public static void writeNbt(NBTTagCompound nbtRoot, IBlockState paintSource) {
        if (nbtRoot == null) {
            return;
        }
        if (paintSource == null) {
            NbtValue.BLOCKSTATE.removeTag(nbtRoot);
        } else {
            NbtValue.BLOCKSTATE.setTag(nbtRoot, NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)paintSource));
        }
    }

    public static IBlockState readNbt(NBTTagCompound nbtRoot) {
        IBlockState paint;
        NBTTagCompound tag;
        if (NbtValue.BLOCKSTATE.hasTag(nbtRoot) && (tag = NbtValue.BLOCKSTATE.getTag(nbtRoot)) != null && (paint = NBTUtil.func_190008_d((NBTTagCompound)tag)) != Blocks.field_150350_a.func_176223_P()) {
            return paint;
        }
        return null;
    }

    public static boolean isPainted(@Nonnull ItemStack itemStack) {
        return NbtValue.BLOCKSTATE.hasTag(itemStack);
    }

    public static IBlockState getSourceBlock(@Nonnull ItemStack itemStack) {
        return PaintUtil.readNbt(itemStack.func_77978_p());
    }

    public static void setPaintSource(@Nonnull ItemStack itemStack, @Nonnull ItemStack paintSource) {
        if (Prep.isInvalid(paintSource)) {
            NbtValue.PAINT_SOURCE.removeTag(itemStack);
        } else {
            paintSource = paintSource.func_77946_l();
            paintSource.func_190920_e(1);
            NbtValue.PAINT_SOURCE.setStack(itemStack, paintSource);
        }
    }

    @Nonnull
    public static ItemStack getPaintSource(@Nonnull ItemStack itemStack) {
        return NbtValue.PAINT_SOURCE.getStack(itemStack);
    }

    public static void setOriginalStack(@Nonnull ItemStack itemStack, @Nonnull ItemStack originalStack) {
        originalStack = originalStack.func_77946_l();
        originalStack.func_190920_e(1);
        NbtValue.ORIGINAL_STACK.setStack(itemStack, originalStack);
    }

    @Nonnull
    public static ItemStack getOriginalStack(@Nonnull ItemStack itemStack) {
        if (NbtValue.ORIGINAL_STACK.hasTag(itemStack)) {
            return NbtValue.ORIGINAL_STACK.getStack(itemStack);
        }
        if (PaintUtil.hasPaintSource(itemStack)) {
            return NbtValue.PAINT_SOURCE.removeTag(NbtValue.BLOCKSTATE.removeTagCopy(itemStack));
        }
        return Prep.getEmpty();
    }

    public static boolean hasPaintSource(@Nonnull ItemStack itemStack) {
        return NbtValue.PAINT_SOURCE.hasTag(itemStack);
    }

    public static void setSourceBlock(@Nonnull ItemStack itemStack, IBlockState paintSource) {
        if (Prep.isInvalid(itemStack)) {
            return;
        }
        if (paintSource == null || paintSource.func_177230_c() == Blocks.field_150350_a) {
            NbtValue.BLOCKSTATE.removeTag(itemStack);
            return;
        }
        try {
            NbtValue.BLOCKSTATE.setTag(itemStack, NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)paintSource));
        }
        catch (Exception e) {
            String s;
            try {
                s = "" + Block.field_149771_c.func_177774_c((Object)paintSource.func_177230_c());
            }
            catch (Exception e1) {
                s = e1.getMessage();
            }
            throw new RuntimeException("Failed to write blockstate to nbt. blockstate=" + paintSource + " registry name=" + s + " block=" + paintSource.func_177230_c(), e);
        }
    }

    public static String getTooltTipText(@Nonnull ItemStack itemStack) {
        String sourceName = null;
        if (itemStack.func_77973_b() instanceof IWithPaintName) {
            sourceName = ((IWithPaintName)itemStack.func_77973_b()).getPaintName(itemStack);
        } else {
            Block block;
            IBlockState state = PaintUtil.getSourceBlock(itemStack);
            if (state != null && (block = state.func_177230_c()) != Blocks.field_150350_a) {
                Item itemFromBlock = Item.func_150898_a((Block)block);
                if (itemFromBlock != Items.field_190931_a) {
                    ItemStack is = new ItemStack(itemFromBlock, 1, block.func_176201_c(state));
                    sourceName = is.func_82833_r();
                } else {
                    sourceName = block.func_149732_F();
                }
            }
        }
        if (sourceName == null || sourceName.isEmpty()) {
            return Lang.PAINTED_NOT.get();
        }
        return Lang.PAINTED_WITH.get(sourceName);
    }

    @Nonnull
    public static ItemStack getPaintAsStack(IBlockState state) {
        Block block;
        Item itemFromBlock;
        if (state != null && (itemFromBlock = Item.func_150898_a((Block)(block = state.func_177230_c()))) != Items.field_190931_a) {
            return new ItemStack(itemFromBlock, 1, block.func_176201_c(state));
        }
        return Prep.getEmpty();
    }

    public static boolean shouldHaveModel(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_176223_P().func_185901_i() == EnumBlockRenderType.MODEL;
    }

    public static boolean shouldHaveTexture(Block block) {
        if (block == null) {
            return false;
        }
        EnumBlockRenderType rt = block.func_176223_P().func_185901_i();
        return rt != EnumBlockRenderType.INVISIBLE;
    }

    public static Block getBlockFromItem(Item itemIn) {
        if (itemIn != null) {
            if (itemIn instanceof ItemBlock) {
                Block block = ((ItemBlock)itemIn).func_179223_d();
                if (NullHelper.untrust((Object)block) == null) {
                    Log.warn("ItemBlock " + itemIn + " returned null from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(itemIn) + "'.");
                } else if (NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                    throw new RuntimeException("ItemBlock " + itemIn + " returned an unregistered block from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(itemIn) + "'.");
                }
                return block;
            }
            FluidStack fluidStack = FluidUtil.getFluidTypeFromItem((ItemStack)new ItemStack(itemIn));
            if (fluidStack != null && fluidStack.getFluid() != null) {
                Block block = fluidStack.getFluid().getBlock();
                if (block != null && NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                    throw new RuntimeException("Fluid " + fluidStack.getFluid() + " (" + fluidStack.getFluid().getName() + ", " + fluidStack.getFluid().getClass() + ") from item " + itemIn + " returned an unregistered block from getBlock(). This is a major bug in the mod that fluid belongs to.");
                }
                return block;
            }
        }
        return null;
    }

    public static Block getBlockFromItem(@Nonnull ItemStack itemStack) {
        if (Prep.isValid(itemStack)) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
                if (NullHelper.untrust((Object)block) == null) {
                    Log.warn("ItemBlock " + itemStack + " returned null from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(itemStack.func_77973_b()) + "'.");
                } else if (NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                    throw new RuntimeException("ItemBlock " + itemStack + " returned an unregistered block from getBlock(). This is a major bug in the mod '" + PaintUtil.block2Modname(itemStack.func_77973_b()) + "'.");
                }
                return block;
            }
            FluidStack fluidStack = FluidUtil.getFluidTypeFromItem((ItemStack)itemStack);
            if (fluidStack != null && fluidStack.getFluid() != null) {
                Block block = fluidStack.getFluid().getBlock();
                if (block != null && NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)block)) == null) {
                    throw new RuntimeException("Fluid " + fluidStack.getFluid() + " (" + fluidStack.getFluid().getName() + ", " + fluidStack.getFluid().getClass() + ") from item " + itemStack + " returned an unregistered block from getBlock(). This is a major bug in the mod that fluid belongs to.");
                }
                return block;
            }
        }
        return null;
    }

    public static boolean canRenderInLayer(@Nullable IBlockState paintSource, @Nullable BlockRenderLayer blockLayer) {
        if (blockLayer == null) {
            return true;
        }
        if (paintSource != null) {
            return paintSource.func_177230_c().canRenderInLayer(paintSource, blockLayer);
        }
        return blockLayer == BlockRenderLayer.SOLID;
    }

    public static IBlockState Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(ItemStack paintSource, Block paintBlock) {
        IBlockState stateFromMeta;
        if (paintSource.func_77973_b().getClass() == ItemPiston.class) {
            return paintBlock.func_176223_P();
        }
        try {
            stateFromMeta = paintBlock.func_176203_a(paintSource.func_77973_b().func_77647_b(paintSource.func_77960_j()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Block %s (%s) belonging to item %s failed to convert its item damage into a blockstate. This is a bug in the mod '%s'.", paintBlock, paintBlock.getClass(), paintSource, PaintUtil.block2Modname(paintBlock)), e);
        }
        if (NullHelper.untrust((Object)stateFromMeta) == null) {
            throw new RuntimeException(String.format("Block %s (%s) belonging to item %s returned null from getStateFromMeta(). This is a major bug in the mod '%s'.", paintBlock, paintBlock.getClass(), paintSource, PaintUtil.block2Modname(paintBlock)));
        }
        if (NullHelper.untrust((Object)stateFromMeta.func_177230_c()) == null) {
            throw new RuntimeException(String.format("Block %s (%s) belonging to item %s returned a blockstate (%s) without block from getStateFromMeta(). This is a major bug in the mod '%s'.", paintBlock, paintBlock.getClass(), paintSource, stateFromMeta, PaintUtil.block2Modname(paintBlock)));
        }
        if (NullHelper.untrust((Object)Block.field_149771_c.func_177774_c((Object)stateFromMeta.func_177230_c())) == null) {
            throw new RuntimeException(String.format("Block %s (%s) belonging to item %s returned a blockstate (%s) that belongs to an unregistered block %s from getStateFromMeta(). This is a major bug in the mod '%s'.", paintBlock, paintBlock.getClass(), paintSource, stateFromMeta, stateFromMeta.func_177230_c(), PaintUtil.block2Modname(paintBlock)));
        }
        return stateFromMeta;
    }

    @Nonnull
    public static String block2Modname(IForgeRegistryEntry<?> block) {
        String name;
        ModContainer modContainer;
        String modid;
        ResourceLocation registryName;
        if (block != null && (registryName = block.getRegistryName()) != null && !Strings.isBlank((String)(modid = registryName.func_110624_b())) && (modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modid)) != null && (name = modContainer.getName()) != null && !name.trim().isEmpty()) {
            return name;
        }
        return "(???)";
    }

    public static void registerPaintable(Block ... blocks) {
        for (Block block : blocks) {
            if (block instanceof IPaintable) continue;
            paintables.add(block);
        }
    }

    public static void registerPaintable(Item ... items) {
        for (Item item : items) {
            if (Block.func_149634_a((Item)item) instanceof IPaintable) continue;
            paintables.add(item);
        }
    }

    public static boolean isPaintable(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return PaintUtil.isPainted(stack) || Block.func_149634_a((Item)stack.func_77973_b()) instanceof IPaintable || paintables.contains(stack);
    }

    public static interface IWithPaintName {
        @Nullable
        public String getPaintName(@Nonnull ItemStack var1);
    }
}

