/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.handler.season.BirchColorHandler;
import sereneseasons.handler.season.RandomUpdateHandler;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.handler.season.SeasonSleepHandler;
import sereneseasons.handler.season.SeasonalCropGrowthHandler;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColourUtil;

public class ModHandlers {
    private static final SeasonHandler SEASON_HANDLER = new SeasonHandler();
    @SideOnly(value=Side.CLIENT)
    private static BiomeColorHelper.ColorResolver originalGrassColorResolver;
    @SideOnly(value=Side.CLIENT)
    private static BiomeColorHelper.ColorResolver originalFoliageColorResolver;

    public static void init() {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)SEASON_HANDLER);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)SEASON_HANDLER);
        SeasonHelper.dataProvider = SEASON_HANDLER;
        MinecraftForge.EVENT_BUS.register((Object)new RandomUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonSleepHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonalCropGrowthHandler());
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModHandlers.registerSeasonColourHandlers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerSeasonColourHandlers() {
        originalGrassColorResolver = BiomeColorHelper.field_180291_a;
        originalFoliageColorResolver = BiomeColorHelper.field_180289_b;
        BiomeColorHelper.field_180291_a = (biome, blockPosition) -> {
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biome) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColourUtil.applySeasonalGrassColouring(colorProvider, biome, originalGrassColorResolver.func_180283_a(biome, blockPosition));
        };
        BiomeColorHelper.field_180289_b = (biome, blockPosition) -> {
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biome) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColourUtil.applySeasonalFoliageColouring(colorProvider, biome, originalFoliageColorResolver.func_180283_a(biome, blockPosition));
        };
    }

    public static void postInit() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            BirchColorHandler.init();
        }
    }
}

