/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook;

import com.yyon.grapplinghook.GrappleConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class GrappleCustomization {
    public static final String[] booleanoptions = new String[]{"phaserope", "motor", "motorwhencrouching", "motorwhennotcrouching", "smartmotor", "enderstaff", "repel", "attract", "doublehook", "smartdoublemotor", "motordampener", "reelin", "pullbackwards", "oneropepull"};
    public static final String[] doubleoptions = new String[]{"maxlen", "hookgravity", "throwspeed", "motormaxspeed", "motoracceleration", "playermovementmult", "repelforce", "attractradius", "angle", "sneakingangle", "verticalthrowangle", "sneakingverticalthrowangle"};
    public double maxlen = GrappleConfig.default_maxlen;
    public boolean phaserope = GrappleConfig.default_phaserope;
    public double hookgravity = GrappleConfig.default_hookgravity;
    public double throwspeed = GrappleConfig.default_throwspeed;
    public boolean reelin = GrappleConfig.default_reelin;
    public double verticalthrowangle = GrappleConfig.default_verticalthrowangle;
    public double sneakingverticalthrowangle = GrappleConfig.default_sneakingverticalthrowangle;
    public boolean motor = GrappleConfig.default_motor;
    public double motormaxspeed = GrappleConfig.default_motormaxspeed;
    public double motoracceleration = GrappleConfig.default_motoracceleration;
    public boolean motorwhencrouching = GrappleConfig.default_motorwhencrouching;
    public boolean motorwhennotcrouching = GrappleConfig.default_motorwhennotcrouching;
    public boolean smartmotor = GrappleConfig.default_smartmotor;
    public boolean motordampener = GrappleConfig.default_motordampener;
    public boolean pullbackwards = GrappleConfig.default_pullbackwards;
    public double playermovementmult = GrappleConfig.default_playermovementmult;
    public boolean enderstaff = GrappleConfig.default_enderstaff;
    public boolean repel = GrappleConfig.default_repel;
    public double repelforce = GrappleConfig.default_repelforce;
    public boolean attract = GrappleConfig.default_attract;
    public double attractradius = GrappleConfig.default_attractradius;
    public boolean doublehook = GrappleConfig.default_doublehook;
    public boolean smartdoublemotor = GrappleConfig.default_smartdoublemotor;
    public double angle = GrappleConfig.default_angle;
    public double sneakingangle = GrappleConfig.default_sneakingangle;
    public boolean oneropepull = GrappleConfig.default_oneropepull;

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (String option : booleanoptions) {
            compound.func_74757_a(option, this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            compound.func_74780_a(option, this.getDouble(option));
        }
        return compound;
    }

    public void loadNBT(NBTTagCompound compound) {
        for (String option : booleanoptions) {
            this.setBoolean(option, compound.func_74767_n(option));
        }
        for (String option : doubleoptions) {
            this.setDouble(option, compound.func_74769_h(option));
        }
    }

    public void setBoolean(String option, boolean bool) {
        if (option.equals("phaserope")) {
            this.phaserope = bool;
        } else if (option.equals("motor")) {
            this.motor = bool;
        } else if (option.equals("motorwhencrouching")) {
            this.motorwhencrouching = bool;
        } else if (option.equals("motorwhennotcrouching")) {
            this.motorwhennotcrouching = bool;
        } else if (option.equals("smartmotor")) {
            this.smartmotor = bool;
        } else if (option.equals("enderstaff")) {
            this.enderstaff = bool;
        } else if (option.equals("repel")) {
            this.repel = bool;
        } else if (option.equals("attract")) {
            this.attract = bool;
        } else if (option.equals("doublehook")) {
            this.doublehook = bool;
        } else if (option.equals("smartdoublemotor")) {
            this.smartdoublemotor = bool;
        } else if (option.equals("motordampener")) {
            this.motordampener = bool;
        } else if (option.equals("reelin")) {
            this.reelin = bool;
        } else if (option.equals("pullbackwards")) {
            this.pullbackwards = bool;
        } else if (option.equals("oneropepull")) {
            this.oneropepull = bool;
        }
    }

    public boolean getBoolean(String option) {
        if (option.equals("phaserope")) {
            return this.phaserope;
        }
        if (option.equals("motor")) {
            return this.motor;
        }
        if (option.equals("motorwhencrouching")) {
            return this.motorwhencrouching;
        }
        if (option.equals("motorwhennotcrouching")) {
            return this.motorwhennotcrouching;
        }
        if (option.equals("smartmotor")) {
            return this.smartmotor;
        }
        if (option.equals("enderstaff")) {
            return this.enderstaff;
        }
        if (option.equals("repel")) {
            return this.repel;
        }
        if (option.equals("attract")) {
            return this.attract;
        }
        if (option.equals("doublehook")) {
            return this.doublehook;
        }
        if (option.equals("smartdoublemotor")) {
            return this.smartdoublemotor;
        }
        if (option.equals("motordampener")) {
            return this.motordampener;
        }
        if (option.equals("reelin")) {
            return this.reelin;
        }
        if (option.equals("pullbackwards")) {
            return this.pullbackwards;
        }
        if (option.equals("oneropepull")) {
            return this.oneropepull;
        }
        System.out.println("Option doesn't exist: " + option);
        return false;
    }

    public void setDouble(String option, double d) {
        if (option.equals("maxlen")) {
            this.maxlen = d;
        } else if (option.equals("hookgravity")) {
            this.hookgravity = d;
        } else if (option.equals("throwspeed")) {
            this.throwspeed = d;
        } else if (option.equals("motormaxspeed")) {
            this.motormaxspeed = d;
        } else if (option.equals("motoracceleration")) {
            this.motoracceleration = d;
        } else if (option.equals("playermovementmult")) {
            this.playermovementmult = d;
        } else if (option.equals("repelforce")) {
            this.repelforce = d;
        } else if (option.equals("attractradius")) {
            this.attractradius = d;
        } else if (option.equals("angle")) {
            this.angle = d;
        } else if (option.equals("sneakingangle")) {
            this.sneakingangle = d;
        } else if (option.equals("verticalthrowangle")) {
            this.verticalthrowangle = d;
        } else if (option.equals("sneakingverticalthrowangle")) {
            this.sneakingverticalthrowangle = d;
        }
    }

    public double getDouble(String option) {
        if (option.equals("maxlen")) {
            return this.maxlen;
        }
        if (option.equals("hookgravity")) {
            return this.hookgravity;
        }
        if (option.equals("throwspeed")) {
            return this.throwspeed;
        }
        if (option.equals("motormaxspeed")) {
            return this.motormaxspeed;
        }
        if (option.equals("motoracceleration")) {
            return this.motoracceleration;
        }
        if (option.equals("playermovementmult")) {
            return this.playermovementmult;
        }
        if (option.equals("repelforce")) {
            return this.repelforce;
        }
        if (option.equals("attractradius")) {
            return this.attractradius;
        }
        if (option.equals("angle")) {
            return this.angle;
        }
        if (option.equals("sneakingangle")) {
            return this.sneakingangle;
        }
        if (option.equals("verticalthrowangle")) {
            return this.verticalthrowangle;
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return this.sneakingverticalthrowangle;
        }
        System.out.println("Option doesn't exist: " + option);
        return 0.0;
    }

    public void writeToBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            buf.writeBoolean(this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            buf.writeDouble(this.getDouble(option));
        }
    }

    public void readFromBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            this.setBoolean(option, buf.readBoolean());
        }
        for (String option : doubleoptions) {
            this.setDouble(option, buf.readDouble());
        }
    }

    public String getName(String option) {
        if (option.equals("maxlen")) {
            return "Rope Length";
        }
        if (option.equals("phaserope")) {
            return "Phase Rope";
        }
        if (option.equals("hookgravity")) {
            return "Gravity on hook";
        }
        if (option.equals("throwspeed")) {
            return "Throw Speed";
        }
        if (option.equals("reelin")) {
            return "Crouch to Reel In";
        }
        if (option.equals("verticalthrowangle")) {
            return "Vertical Throw Angle";
        }
        if (option.equals("motor")) {
            return "Motor Enabled";
        }
        if (option.equals("motormaxspeed")) {
            return "Motor Maximum Speed";
        }
        if (option.equals("motoracceleration")) {
            return "Motor Acceleration";
        }
        if (option.equals("motorwhencrouching")) {
            return "Motor when crouching";
        }
        if (option.equals("motorwhennotcrouching")) {
            return "Motor when not crouching";
        }
        if (option.equals("smartmotor")) {
            return "Smart Motor";
        }
        if (option.equals("motordampener")) {
            return "Sideways Motion Dampener";
        }
        if (option.equals("pullbackwards")) {
            return "Pull Backwards";
        }
        if (option.equals("playermovementmult")) {
            return "Swing speed";
        }
        if (option.equals("enderstaff")) {
            return "Ender Staff";
        }
        if (option.equals("repel")) {
            return "Forcefield Enabled";
        }
        if (option.equals("repelforce")) {
            return "Repel Force";
        }
        if (option.equals("attract")) {
            return "Magnet Enabled";
        }
        if (option.equals("attractradius")) {
            return "Attraction Radius";
        }
        if (option.equals("doublehook")) {
            return "Double Hook";
        }
        if (option.equals("smartdoublemotor")) {
            return "Smart Motor";
        }
        if (option.equals("angle")) {
            return "Angle";
        }
        if (option.equals("sneakingangle")) {
            return "Angle when crouching";
        }
        if (option.equals("oneropepull")) {
            return "Allow pulling with one rope";
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return "Crouching Vertical Angle ";
        }
        return "unknown option";
    }

    public String getDescription(String option) {
        if (option.equals("maxlen")) {
            return "The length of the rope";
        }
        if (option.equals("phaserope")) {
            return "Allows rope to phase through blocks";
        }
        if (option.equals("hookgravity")) {
            return "Gravity on hook when thrown";
        }
        if (option.equals("throwspeed")) {
            return "Speed of hook when thrown";
        }
        if (option.equals("reelin")) {
            return "Before the hook is attached, crouching will stop the hook from moving farther and slowly reel it in";
        }
        if (option.equals("verticalthrowangle")) {
            return "Throws the grappling hook above the crosshairs by this angle";
        }
        if (option.equals("motor")) {
            return "Pulls player towards hook";
        }
        if (option.equals("motormaxspeed")) {
            return "Maximum speed of motor";
        }
        if (option.equals("motoracceleration")) {
            return "Acceleration of motor";
        }
        if (option.equals("motorwhencrouching")) {
            return "Motor is active when crouching";
        }
        if (option.equals("motorwhennotcrouching")) {
            return "Motor is active when crouching";
        }
        if (option.equals("smartmotor")) {
            return "Adjusts motor speed so that player moves towards crosshairs (up/down)";
        }
        if (option.equals("motordampener")) {
            return "Reduces motion perpendicular to the rope so that the rope pulls straighter";
        }
        if (option.equals("pullbackwards")) {
            return "Motor pulls even if you are facing the other way";
        }
        if (option.equals("playermovementmult")) {
            return "Acceleration of player when using movement keys while swinging";
        }
        if (option.equals("enderstaff")) {
            return "Left click launches player forwards";
        }
        if (option.equals("repel")) {
            return "Player is repelled from nearby blocks when swinging";
        }
        if (option.equals("repelforce")) {
            return "Force nearby blocks exert on the player";
        }
        if (option.equals("attract")) {
            return "Hook is attracted to nearby blocks when thrown";
        }
        if (option.equals("attractradius")) {
            return "Radius of attraction";
        }
        if (option.equals("doublehook")) {
            return "Two hooks are thrown at once";
        }
        if (option.equals("smartdoublemotor")) {
            return "Adjusts motor speed so that player moves towards crosshairs (left/right) when used with motor";
        }
        if (option.equals("angle")) {
            return "Angle that each hook is thrown from center";
        }
        if (option.equals("sneakingangle")) {
            return "Angle that each hook is thrown from center when crouching (don't have 'crouch to reel in' enabled if you want to use this)";
        }
        if (option.equals("oneropepull")) {
            return "When motor is enabled and only one hook is attached, activate the motor (if disabled, wait until both hooks are attached before pulling)";
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return "Throws the grappling hook above the crosshairs by this angle when crouching";
        }
        return "unknown option";
    }

    public boolean isoptionvalid(String option) {
        if (option == "motormaxspeed" || option == "motoracceleration" || option == "motorwhencrouching" || option == "motorwhennotcrouching" || option == "smartmotor" || option == "motordampener" || option == "pullbackwards") {
            return this.motor;
        }
        if (option == "sneakingangle") {
            return this.doublehook && !this.reelin;
        }
        if (option == "repelforce") {
            return this.repel;
        }
        if (option == "attractradius") {
            return this.attract;
        }
        if (option == "angle") {
            return this.doublehook;
        }
        if (option == "smartdoublemotor" || option == "oneropepull") {
            return this.doublehook && this.motor;
        }
        return true;
    }

    public double getMax(String option, int upgrade) {
        if (option.equals("maxlen")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_maxlen : GrappleConfig.max_maxlen;
        }
        if (option.equals("hookgravity")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_hookgravity : GrappleConfig.max_hookgravity;
        }
        if (option.equals("throwspeed")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_throwspeed : GrappleConfig.max_throwspeed;
        }
        if (option.equals("motormaxspeed")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_motormaxspeed : GrappleConfig.max_motormaxspeed;
        }
        if (option.equals("motoracceleration")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_motoracceleration : GrappleConfig.max_motoracceleration;
        }
        if (option.equals("playermovementmult")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_playermovementmult : GrappleConfig.max_playermovementmult;
        }
        if (option.equals("repelforce")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_repelforce : GrappleConfig.max_repelforce;
        }
        if (option.equals("attractradius")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_attractradius : GrappleConfig.max_attractradius;
        }
        if (option.equals("angle")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_angle : GrappleConfig.max_angle;
        }
        if (option.equals("sneakingangle")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_sneakingangle : GrappleConfig.max_sneakingangle;
        }
        if (option.equals("verticalthrowangle")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_verticalthrowangle : GrappleConfig.max_verticalthrowangle;
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return upgrade == 1 ? GrappleConfig.max_upgrade_sneakingverticalthrowangle : GrappleConfig.max_sneakingverticalthrowangle;
        }
        System.out.println("Option doesn't exist: " + option);
        return 0.0;
    }

    public double getMin(String option, int upgrade) {
        if (option.equals("hookgravity")) {
            return upgrade == 1 ? GrappleConfig.min_upgrade_hookgravity : GrappleConfig.min_hookgravity;
        }
        return 0.0;
    }

    public int optionEnabled(String option) {
        if (option.equals("maxlen")) {
            return GrappleConfig.enable_maxlen;
        }
        if (option.equals("phaserope")) {
            return GrappleConfig.enable_phaserope;
        }
        if (option.equals("hookgravity")) {
            return GrappleConfig.enable_hookgravity;
        }
        if (option.equals("throwspeed")) {
            return GrappleConfig.enable_throwspeed;
        }
        if (option.equals("reelin")) {
            return GrappleConfig.enable_reelin;
        }
        if (option.equals("verticalthrowangle")) {
            return GrappleConfig.enable_verticalthrowangle;
        }
        if (option.equals("motor")) {
            return GrappleConfig.enable_motor;
        }
        if (option.equals("motormaxspeed")) {
            return GrappleConfig.enable_motormaxspeed;
        }
        if (option.equals("motoracceleration")) {
            return GrappleConfig.enable_motoracceleration;
        }
        if (option.equals("motorwhencrouching")) {
            return GrappleConfig.enable_motorwhencrouching;
        }
        if (option.equals("motorwhennotcrouching")) {
            return GrappleConfig.enable_motorwhennotcrouching;
        }
        if (option.equals("smartmotor")) {
            return GrappleConfig.enable_smartmotor;
        }
        if (option.equals("motordampener")) {
            return GrappleConfig.enable_motordampener;
        }
        if (option.equals("pullbackwards")) {
            return GrappleConfig.enable_pullbackwards;
        }
        if (option.equals("playermovementmult")) {
            return GrappleConfig.enable_playermovementmult;
        }
        if (option.equals("enderstaff")) {
            return GrappleConfig.enable_enderstaff;
        }
        if (option.equals("repel")) {
            return GrappleConfig.enable_repel;
        }
        if (option.equals("repelforce")) {
            return GrappleConfig.enable_repelforce;
        }
        if (option.equals("attract")) {
            return GrappleConfig.enable_attract;
        }
        if (option.equals("attractradius")) {
            return GrappleConfig.enable_attractradius;
        }
        if (option.equals("doublehook")) {
            return GrappleConfig.enable_doublehook;
        }
        if (option.equals("smartdoublemotor")) {
            return GrappleConfig.enable_smartdoublemotor;
        }
        if (option.equals("angle")) {
            return GrappleConfig.enable_angle;
        }
        if (option.equals("sneakingangle")) {
            return GrappleConfig.enable_sneakingangle;
        }
        if (option.equals("oneropepull")) {
            return GrappleConfig.enable_oneropepull;
        }
        if (option.equals("sneakingverticalthrowangle")) {
            return GrappleConfig.enable_sneakingverticalthrowangle;
        }
        System.out.println("Unknown option");
        return 0;
    }
}

