/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.forestry.list;

import buildcraft.api.lists.ListMatchHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ListMatchGenome
extends ListMatchHandler {
    public boolean matches(ListMatchHandler.Type type, ItemStack compare, ItemStack target, boolean precise) {
        IIndividual infoCompare = AlleleManager.alleleRegistry.getIndividual(compare);
        IIndividual infoTarget = AlleleManager.alleleRegistry.getIndividual(target);
        if (infoCompare == null || infoTarget == null) {
            return false;
        }
        switch (type) {
            case MATERIAL: {
                return ListMatchGenome.matchesMaterial(compare, target, infoCompare, infoTarget, precise);
            }
            case TYPE: {
                return ListMatchGenome.matchesType(compare, target, infoCompare, infoTarget, precise);
            }
            case CLASS: {
                return ListMatchGenome.matchesMaterial(compare, target, infoCompare, infoTarget, precise) && ListMatchGenome.matchesType(compare, target, infoCompare, infoTarget, precise);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private static boolean matchesMaterial(ItemStack compare, ItemStack target, IIndividual infoCompare, IIndividual infoTarget, boolean precise) {
        IAlleleSpecies inactiveTarget;
        IAlleleSpecies inactiveCompare;
        IAlleleSpecies speciesTarget;
        IAlleleSpecies speciesCompare = infoCompare.getGenome().getPrimary();
        if (speciesCompare != (speciesTarget = infoTarget.getGenome().getPrimary())) {
            return false;
        }
        return !precise || (inactiveCompare = infoCompare.getGenome().getSecondary()) == (inactiveTarget = infoTarget.getGenome().getSecondary());
    }

    private static boolean matchesType(ItemStack compare, ItemStack target, IIndividual infoCompare, IIndividual infoTarget, boolean precise) {
        ISpeciesRoot speciesRootTarget;
        ISpeciesRoot speciesRootCompare = infoCompare.getGenome().getSpeciesRoot();
        if (speciesRootCompare != (speciesRootTarget = infoTarget.getGenome().getSpeciesRoot())) {
            return false;
        }
        return speciesRootCompare.getType(compare) == speciesRootTarget.getType(target);
    }

    public boolean isValidSource(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        return AlleleManager.alleleRegistry.getIndividual(stack) != null;
    }

    @Nullable
    public NonNullList<ItemStack> getClientExamples(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(stack);
        if (individual == null) {
            return null;
        }
        NonNullList list = NonNullList.func_191196_a();
        boolean isType = type != ListMatchHandler.Type.MATERIAL;
        boolean isMaterial = type != ListMatchHandler.Type.TYPE;
        return list;
    }
}

