/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.waila;

import buildcraft.api.mj.ILaserTarget;
import buildcraft.api.mj.MjAPI;
import buildcraft.compat.module.waila.BaseWailaDataProvider;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

class LaserTargetDataProvider
extends BaseWailaDataProvider {
    LaserTargetDataProvider() {
    }

    @Override
    @Nonnull
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof ILaserTarget) {
            long power;
            NBTTagCompound nbt = accessor.getNBTData();
            if (nbt.func_150297_b("required_power", 4) && (power = nbt.func_74763_f("required_power")) > 0L) {
                currentTip.add(TextFormatting.WHITE + "Waiting from laser: " + TextFormatting.AQUA + MjAPI.formatMj((long)power) + " MJ");
            }
        } else {
            currentTip.add(TextFormatting.RED + "{wrong tile entity}");
        }
        return currentTip;
    }

    @Override
    @Nonnull
    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        NBTTagCompound nbt = super.getNBTData(player, te, tag, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ILaserTarget) {
            ILaserTarget target = (ILaserTarget)ILaserTarget.class.cast(tile);
            nbt.func_74772_a("required_power", target.getRequiredLaserPower());
        }
        return nbt;
    }
}

